# -*- coding: shift-jis -*-

import math
import maya.OpenMaya as om


def getRotationFromVectors(xAxis, yAxis, zAxis, rotateOrder="xyz"):
    u"""]xNgIC[pvZ܂B

    :type xAxis: Vector or None
    :type yAxis: Vector or None
    :type zAxis: Vector or None
    :param str rotateOrder: ]w肷镶B
    :rtype: tuple of float
    :returns: (rx, ry, rz)
    """

    # ]萔lɕϊ
    attr = "k" + rotateOrder.upper()
    func = getattr(om.MEulerRotation, attr)
    order = func

    mm = om.MMatrix()
    for i, vec in enumerate((xAxis, yAxis, zAxis)):
        vals = vec.get()
        om.MScriptUtil.setDoubleArray(mm[i], 0, vals[0])
        om.MScriptUtil.setDoubleArray(mm[i], 1, vals[1])
        om.MScriptUtil.setDoubleArray(mm[i], 2, vals[2])

    er = om.MEulerRotation.decompose(mm, order)
    orient = [math.degrees(r) for r in er]

    return orient
