# -*- coding: shift-jis -*-

import re

import maya.OpenMaya as om
import pymel.core as pm
import pymel.core.nodetypes as nt
from ..string import getUnicode


def getGroupByObject(components):
    u"""bVR|[lgIuWFNgɃO[v܂B

    :type: list of Component or unicode
    :rtype: {DependNode: list of Component}
    :returns: em[hL[ɎB
    """

    # tF[XXgbVɃO[v
    groups = {}
    setDefault = groups.setdefault
    current = ""
    for comp in components:
        if not isinstance(comp, pm.Component):
            comp = pm.PyNode(comp)

        obj = comp.node()  # str(comp).split(".")[0]
        if current != obj:
            current = obj
            addFace = setDefault(obj, []).append
        addFace(comp)

    return groups


def getVertComponents(vertIds):
    u"""w肵vf_R|[lgIuWFNg쐬܂B

    :param int numVerts: R|[lg̒_B
    :rtype: OpenMaya.MFnSingleIndexedComponent
    """

    compFn = om.MFnSingleIndexedComponent()
    components = compFn.create(om.MFn.kMeshVertComponent)
    util = om.MScriptUtil()
    util.createFromList(vertIds, len(vertIds))
    vertIdcs = om.MIntArray(util.asIntPtr(), len(vertIds))
    compFn.addElements(vertIdcs)

    return components


def getDagPath(path):
    u"""pX񂩂MDagPathIuWFNg쐬܂B

    :type path: unicode
    :rtype: maya.OpenMaya.MDagPath
    """

    dagPath = om.MDagPath()
    sl = om.MSelectionList()
    sl.add(path)
    sl.getDagPath(0, dagPath)

    return dagPath


def getDependObject(path):
    u"""pX񂩂Dependencym[h\MObject쐬܂B

    :type path: unicode
    :rtype: maya.OpenMaya.MObject
    """

    depObj = om.MObject()
    sl = om.MSelectionList()
    sl.add(path)
    sl.getDependNode(0, depObj)

    return depObj


def getDagPathAndObject(path):
    u"""pX񂩂MDagPathMObject쐬܂B

    :type path: unicode
    :rtype: (maya.OpenMaya.MDagPath, maya.OpenMaya.MObject)
    """

    dagPath = om.MDagPath()
    compObj = om.MObject()
    sl = om.MSelectionList()
    sl.add(path)
    sl.getDagPath(0, dagPath, compObj)

    return (dagPath, compObj)


def listToMIntArray(intList):
    u"""XgMIntArray֕ϊ܂B

    :type intList: int list
    :rtype: maya.OpenMaya.MIntArray
    """

    num = len(intList)
    util = om.MScriptUtil()
    util.createFromList(intList, num)
    array = om.MIntArray(util.asIntPtr(), num)
    return array


def listToMDoubleArray(floatList):
    u"""XgMDoubleArray֕ϊ܂B

    :type floatList: float list
    :rtype: maya.OpenMaya.MDoubleArray
    """

    num = len(floatList)
    util = om.MScriptUtil()
    util.createFromList(floatList, num)
    array = om.MDoubleArray(util.asDoublePtr(), num)
    return array


def filterTransform(objects, shapeType=None):
    u"""̃VFCvgXtH[݂̂𒊏o܂B

    :param objects: IuWFNg̃XgB
    :type objects: pymel.core.nodetypes.DependNode
    :param shapeType: w肵VFCvgXtH[݂̂𒊏o܂B
                      ^vŕw肷邱Ƃł܂B
                      Nonew肷ƃVFCvw肵܂񂪁A
                      type(None)͋̃gXtH[(O[v)\܂B
    :type shapeType: type or None or tuple
    :rtype: pymel.core.nodetypes.Transform list
    """

    result = []
    append = result.append
    for obj in objects:
        if isinstance(obj, nt.Transform):
            if shapeType:
                if isinstance(obj.getShape(), shapeType):
                    append(obj)
            else:
                append(obj)
        elif isinstance(obj, shapeType):
            try:
                parent = obj.getParent()
                if isinstance(parent, nt.Transform):
                    append(parent)
            except:
                pass

    return result


def separateTransform(node):
    u"""TransformShapeꂼ擾܂.

    :type node: Transform or Shape
    :rtype: tuple
    :returns: (Transform, Shape)
    """
    if isinstance(node, nt.Transform):
        return node, node.getShape()
    else:
        return node.getParent(), node


def getComponentIDs(components):
    u"""Xg̑SẴR|[lgIDWJĎ擾܂B

    :param components: R|[lgIuWFNg̃XgB
    :type components: DiscreteComponent list or unicode list
    :rtype: int list
    """

    if not components:
        return []

    if not isinstance(components[0], pm.DiscreteComponent):
        components = [pm.PyNode(c) for c in components]

    ids = []
    extend = ids.extend
    for comp in components:
        extend(comp.indices())

    return ids


def getInvertIDs(ids, numIDs):
    u"""R|[lgIDXg𔽓]Ď擾܂B

    :param ids: ID̃XgB
    :type ids:@int list
    :param numIDs: R|[lg
    :type numIDs: int
    :rtype: int list
    :returns: IDXgɊ܂܂ĂȂID݂̂ێXgB
    """

    return list(set(xrange(numIDs)).difference(ids))


def getComponentsFromIDs(node, attrName, ids):
    u"""R|[lgIDR|[lg擾܂B

    :param node: x[XIuWFNgBMeshB
    :type node: unicode
    :param attrName: R|[lgBf, cv, vtx B
    :type attrName: str
    :param ids: ID̃XgB
    :type ids: int list
    :rtype: str list
    """

    base = str(node) + "." + attrName + "[%d]"
    return [base % i for i in ids]


def getSlicesFromComponent(component, hasInteger=True):
    u"""R|[lgsliceIuWFNg擾܂B

    :param unicode component: R|[lgB
    :param hasInteger: Trueɐݒ肵ꍇAPCfbNXintŎ擾܂B
    :type hasInteger: bool
    :rtype: list
    :returns: slice܂intlistB
    """

    idstrs = str(component).split("[")[-1].split("]")[0].split(",")
    result = []
    append = result.append
    for s in idstrs:

        sp = s.split(":")
        if len(sp) == 2:
            append(slice(int(sp[0]), int(sp[1]) + 1))
        else:
            n = int(sp[0])
            if hasInteger:
                append(n)
            else:
                append(slice(n, n + 1))

    return result


def getSafeName(string, replace="_", defstr="", mode=0):
    u"""MayaŎgp\ȕ֕ϊ܂B

    :param string: Ώە
    :param replace: u
    :param defstr: modeQƁB
    :param mode: 0: gpsreplaceŒu܂B
                    ŏIIɋ󕶎ꍇAdefstrԂ܂B
                 1: gps1ł܂܂邩A󕶎ꍇ
                    defstrԂ܂B
                 2: SĂ̕gpsꍇdefstrԂ܂B
                    ̑mode=0ƓłB
    :rtype: unicode
    """

    if isinstance(string, str):
        string = getUnicode(string)

    if mode == 1:
        if not string or re.search("\W", string):
            return defstr
        else:
            return string
    elif mode == 2:
        if not re.search("\w", string):
            return defstr

    name = re.sub("\W", replace, string)
    if name:
        return name
    else:
        return defstr
