# -*- coding: shift-jis -*-

import functools


def mproperty(func):
    attr = "_propmemo_" + func.__name__

    @property
    def _wrapper(self):
        if not hasattr(self, attr):
            setattr(self, attr, func(self))
        return getattr(self, attr)

    return _wrapper


def memonode(func):
    u"""\bhɓnŏ̈ŃfR[^."""

    attr = "_cache"

    @functools.wraps(func)
    def _wrapper(self, node, *args, **kw):

        # LbV
        if not hasattr(self, attr):
            setattr(self, attr, {})

        # LbVΕԂ. funcs.
        cache = getattr(self, attr)
        val = cache.get(node)
        if val:
            return val
        else:
            val = func(self, node, *args, **kw)
            cache[node] = val
            return val

    return _wrapper


def id_hash(klass):
    u"""IuWFNgIDŃnbVNXfR[^."""

    def __eq__(self, other):
        return id(self) == id(other)

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return hash(id(self))

    setattr(klass, "__eq__", __eq__)
    setattr(klass, "__ne__", __ne__)
    setattr(klass, "__hash__", __hash__)

    return klass


# # @id_hash
# class Foo(object):
#
#     def __init__(self, val):
#         self.val = val
#
#     def __repr__(self):
#         return str(self.val)
#
#     def __eq__(self, other):
#         return self.val == self.val
#
#     def __ne__(self, other):
#         return not self.__eq__(other)
#
#     def __hash__(self):
#         return hash(self.val)
#
# a = Foo("test1")
# b = Foo("test1")
# c = Foo("test2")
#
# s = set([a, b, c])
# print s
