# -*- coding: shift-jis -*-

import unittest
import math
from pmxio.trutils.collection._indexedlist import IndexedList
import random


class TestObject(object):

    def __init__(self, name=""):
        self.index = -1
        self.name = name

    def __repr__(self):
        return "Test(\"%s\")[%d]" % (self.name, self.index)


def checkindex(func):
    def _wrapper(self, *args, **kw):
        res = func(self, *args, **kw)
        self._check_index()
        return res
    return _wrapper


class IListTest(unittest.TestCase):

    def _check_index(self, items=None, errMsg=None):
        """Check to indices in items."""
        if items is None:
            items = self.testList
        flag = True
        for i, v in enumerate(items):
            if i != v.index:
                flag = False
                print items
                if errMsg:
                    print errMsg
                break
        self.assertTrue(flag)

    def _check_length(self, size):
        self.assertEqual(len(self.testList), size)

    def setUp(self):
        self.testList = IndexedList(TestObject("S%d" % i) for i in range(10))

    # Set Item ---------------------------------------------------------------

    def test_setitem_int(self):
        u""" ͈͓S"""

        for i in range(-10, 9):
            self.testList[i] = TestObject("Set" + str(i))
            self._check_index()
        self._check_length(10)

    def test_setitem_int_out_of_range(self):
        u""" ͈͊OG["""

        for i in range(-15, -11):
            with self.assertRaises(IndexError):
                self.testList[i] = TestObject("Set" + str(i))
        for i in range(10, 15):
            with self.assertRaises(IndexError):
                self.testList[i] = TestObject("Set" + str(i))

    # KvȂiԗeXgŃJo[j
    def test_setitem_slice_fixed_length(self):
        u"""XCX Œ蒷 σXebv"""

        for start in range(11):
            for stop in range(11):
                for step in range(1, 11):  # 1-10

                    length = stop - start
                    if length > 0:
                        length = int(math.ceil(float(length) / step))
                    else:
                        length = 0

                    print "start:", start, " stop:", stop,
                    print " step:", step, " len:", length

                    items = (TestObject("Slice%d" % i) for i in range(length))
                    self.testList[start:stop:step] = items
                    self._check_length(10)
                    self._check_index()
                    print ""

    # KvȂiԗeXgŃJo[j
    def test_setitem_slice_fixed_length_minus(self):
        u"""XCX Œ蒷 σXebv }CiX"""

        for start in range(-11, 0):
            for stop in range(-11, 0):
                for step in range(-10, 0):

                    length = stop - start
                    if length < 0:
                        length = int(math.ceil(float(length) / step))
                    else:
                        length = 0

                    print "start:", start, " stop:", stop,
                    print " step:", step, " len:", length

                    items = (TestObject("Slice%d" % i) for i in range(length))
                    self.testList[start:stop:step] = items
                    self._check_length(10)
                    self._check_index()
                    print ""

    def test_setitem_slice_covering(self):
        u"""XCX ŒEύ ԗeXg"""

        for step in range(-12, 12) + [None]:
            if step == 0:
                continue

            for start in range(-24, 12):
                for stop in range(-24, 12):
                    for length in range(12):

                        msg = ("start: %d, stop: %d, step: %s, length: %d" %
                               (start, stop, str(step), length))

                        items = (TestObject("Slice%d" % i)
                                 for i in range(length))
                        try:
                            self.testList[start:stop:step] = items
                        except ValueError:
                            pass

                        self._check_index(errMsg=msg)
                        self.setUp()

    @checkindex
    def test_setitem_slice_nones(self):
        u"""XCX SNone"""

        length = 5
        items = (TestObject("Slice" + str(j)) for j in range(length))
        self.testList[None:None:None] = items
        self._check_length(length)

    # Set Slice ---------------------------------------------------------------

    def test_setslice_covering(self):
        u"""XCX ԗeXg"""

        for start in range(-24, 12):
            for stop in range(-24, 12):
                for length in range(12):

                    msg = ("start: %d, stop: %d, length: %d" %
                           (start, stop, length))

                    items = (TestObject("Slice%d" % i)
                             for i in range(length))
                    try:
                        self.testList[start:stop] = items
                    except ValueError:
                        pass

                    self._check_index(errMsg=msg)
                    self.setUp()

    @checkindex
    def test_setslice_nones(self):
        u"""XCX SNone"""

        length = 5
        items = (TestObject("Slice" + str(i)) for i in range(length))
        self.testList[None:None] = items
        self._check_length(length)

    # Delete indexers ---------------------------------------------------------

    def test_delitem_int_zero(self):
        u""" 0"""

        for i in range(10):
            del self.testList[0]
            self._check_index()
            self._check_length(9 - i)

    def test_delitem_int_desc(self):
        u""" ~"""

        for i in range(10):
            idx = 9 - i
            del self.testList[idx]
            self._check_index()
            self._check_length(idx)

    def test_delitem_int_minus(self):
        u""" -1"""

        for i in range(10):
            idx = 9 - i
            del self.testList[-1]
            self._check_index()
            self._check_length(idx)

    def test_delitem_int_random(self):
        u""" _ 10 * 100"""

        for i in range(100):
            for j in range(10):
                idx = random.randrange(0, len(self.testList))
                del self.testList[idx]
                self._check_index(errMsg="roop: %d, idx: %d" % (i, idx))
                self._check_length(9 - j)
            self.setUp()

    def test_delitem_int_minus_random(self):
        u""" _ }CiXl 10 * 100"""

        for i in range(100):
            for j in range(10):
                idx = random.randrange(len(self.testList) * -1, 0)
                del self.testList[idx]
                self._check_index(errMsg="roop: %d, idx: %d" % (i, idx))
                self._check_length(9 - j)
            self.setUp()

    def test_delitem_int_out_of_range(self):
        u""" ͈͊OG["""

        for i in range(-15, -11):
            with self.assertRaises(IndexError):
                del self.testList[i]

        for i in range(10, 15):
            with self.assertRaises(IndexError):
                del self.testList[i]

    def test_delitem_slice_covering(self):
        u"""XCX ŒEύ ԗeXg"""

        for step in range(-12, 12) + [None]:
            if step == 0:
                continue
            for start in range(-24, 12):
                for stop in range(-24, 12):
                    for length in range(12):
                        msg = ("start: %d, stop: %d, step: %s, length: %d" %
                               (start, stop, str(step), length))
                        del self.testList[start:stop:step]
                        self._check_index(errMsg=msg)
                        self.setUp()

    @checkindex
    def test_delitem_slice_nones(self):
        u"""XCX SNone"""

        del self.testList[None:None:None]
        self._check_length(0)

    def test_delslice_covering(self):
        u"""XCX ԗeXg"""

        for start in range(-24, 12):
            for stop in range(-24, 12):
                for length in range(12):
                    msg = ("start: %d, stop: %d, length: %d" %
                           (start, stop, length))
                    del self.testList[start:stop]
                    self._check_index(errMsg=msg)
                    self.setUp()

    @checkindex
    def test_delslice_nones(self):
        u"""XCX SNone"""

        del self.testList[None:None]
        self._check_length(0)

    # Addition operators ------------------------------------------------------

    @checkindex
    def test_add5(self):
        self.testList = self.testList + [TestObject("Add") for _ in range(5)]
        self._check_length(15)

    @checkindex
    def test_add1(self):
        self.testList = self.testList + [TestObject("Add")]
        self._check_length(11)

    @checkindex
    def test_add_empty(self):
        self.testList = self.testList + []
        self._check_length(10)

    @checkindex
    def test_iadd5(self):
        self.testList += (TestObject("IAdd") for _ in range(5))
        self._check_length(15)

    @checkindex
    def test_iadd1(self):
        self.testList += (TestObject("IAdd") for _ in range(1))
        self._check_length(11)

    @checkindex
    def test_iadd_empty(self):
        self.testList += (TestObject("IAdd") for _ in range(0))
        self._check_length(10)

    # Append Methods ----------------------------------------------------------

    @checkindex
    def test_append3(self):
        self.testList.append(TestObject("Append1"))
        self.testList.append(TestObject("Append2"))
        self.testList.append(TestObject("Append3"))
        self._check_length(13)

    @checkindex
    def test_extend5(self):
        self.testList.extend(TestObject("Ex") for _ in range(5))
        self._check_length(15)

    @checkindex
    def test_extend1(self):
        self.testList.extend(TestObject("Ex") for _ in range(1))
        self._check_length(11)

    @checkindex
    def test_extend_empty(self):
        self.testList.extend(TestObject("Ex") for _ in range(0))
        self._check_length(10)

    @checkindex
    def test_insert_limit(self):
        self.testList.insert(9, TestObject("Insert1"))
        self._check_index()
        self.testList.insert(0, TestObject("Insert2"))
        self._check_length(12)

    def test_insert_minus(self):
        self.testList.insert(-10, TestObject("Insert1"))
        self._check_index()
        self.testList.insert(-1, TestObject("Insert2"))
        self._check_length(12)

    @checkindex
    def test_insert_out_of_range(self):
        self.testList.insert(10, TestObject("Insert1"))
        self._check_index()
        self.testList.insert(100, TestObject("Insert2"))
        self._check_index()
        self.testList.insert(-100, TestObject("Insert3"))
        self._check_length(13)

    # Remove Methods ----------------------------------------------------------

    @checkindex
    def test_pop(self):
        self.testList.pop()
        self._check_index()
        self.testList.pop(0)
        self._check_index()
        self.testList.pop(-1)
        self._check_length(7)

    def test_pop_out_of_range(self):
        with self.assertRaises(IndexError):
            self.testList.pop(20)
        with self.assertRaises(IndexError):
            self.testList.pop(-100)

    @checkindex
    def test_remove(self):
        rmv = self.testList[5]
        self.testList.remove(rmv)
        self._check_index()

        rmv = self.testList[-1]
        self.testList.remove(rmv)
        self._check_index()

        rmv = self.testList[0]
        self.testList.remove(rmv)
        self._check_length(7)

    # General Methods ---------------------------------------------------------

    @checkindex
    def test_sort(self):
        self.testList.sort()

    @checkindex
    def test_sort_reverse(self):
        self.testList.sort(reverse=True)

    @checkindex
    def test_reverse(self):
        self.testList.reverse()

    @checkindex
    def test_freeze(self):
        self.testList.freeze()
        del self.testList[0:5]
        print self.testList
        self.testList.unfreeze()


if __name__ == "__main__":
    unittest.main()
