# -*- coding: shift-jis -*-

from itertools import groupby
import operator


def between(theMin, val, theMax):
    u"""ŏlƍől̊ԂŒlg~O܂B

    :param theMin: ŏl
    :param val: l
    :param theMax: ől
    """

    if theMin > val:
        return theMin
    elif theMax < val:
        return theMax
    else:
        return val


def groupByCount(count, L):
    u"""w肵JEgɃXCXCe[^B

    :type count: int
    :type L: sliceable
    :rtype: iterator
    """

    for i in xrange(0, len(L), count):
        yield L[i:i + count]


def getGroupByCount(count, L):
    u"""Xgw肵TCYɕăO[v܂B

    :type count: int
    :type L: sliceable
    :rtype: list of list
    """
    return [L[i:i + count] for i in xrange(0, len(L), count)]


def groupByCounts(counts, L):
    u"""w肵JEgɃXCXCe[^B

    :type counts: list of int
    :type L: sliceable
    """

    idx = 0
    for c in counts:
        nextIdx = idx + c
        yield L[idx:nextIdx]
        idx = nextIdx


def getGroupByCounts(counts, L):
    u"""XgLcountsŎw肵TCYɕăO[v܂B

    L = range(10)
    counts = [3, 4, 3]
    => [[0, 1, 2], [3, 4, 5, 6], [7, 8, 9]]

    :type counts: int list
    :type L: sliceable
    :rtype: list of list
    """
    result = []
    append = result.append
    idx = 0
    for c in counts:
        nextIdx = idx + c
        append(L[idx:nextIdx])
        idx = nextIdx

    return result


def getStairsByCounts(counts, offset=0):
    u"""JEgzKiɓWJ܂B

    :type counts: list of int
    :rtype: list of int
    """

    return [i for fi, vc in enumerate(counts) for i in [fi] * vc]


def getGroupBy(L, key=None, sort=True):
    u"""RNV̏ŃO[v܂B

    :param L: RNVB
    :type L: iterable
    :param key: O[vL[w肷֐IuWFNgB
                P̈AO[vL[ԂKv܂B
    :type key: function
    :param bool sort: ^ɂꍇAO[vOɃRNV\[g܂B
                      \[gȂꍇO[vfЉ\܂B
    :rtype: list of list
    :returns: O[vɃXgXgB
    """

    if sort:
        L = sorted(L, key=key)

    result = [list(g[1]) for g in groupby(L, key=key)]
    return result


def accumulate(L, func=operator.add):
    u"""ݐωZ擾Ce[^B

    accumulate([1,2,3,4,5]) --> 1 3 6 10 15
    accumulate([1,2,3,4,5], operator.mul) --> 1 2 6 24 120
    :type L: iterable
    :param func: ZɎgp֐IuWFNgB
                 2̈艉ZʂԂKv܂B
    """

    it = iter(L)
    total = next(it)
    yield total
    for element in it:
        total = func(total, element)
        yield total


def getAccumulate(L, func=operator.add):
    u"""ݐωZ擾܂B

    accumulate([1,2,3,4,5]) --> 1 3 6 10 15
    accumulate([1,2,3,4,5], operator.mul) --> 1 2 6 24 120
    :type L: iterable
    :param func: ZɎgp֐IuWFNgB
                 2̈艉ZʂԂKv܂B
    :rtype: list
    """
    result = []
    append = result.append
    it = iter(L)
    total = next(it)
    append(total)
    for element in it:
        total = func(total, element)
        append(total)

    return result


def popBySlice(L, s):
    u"""Xgw͈̗͂vf擾Aɗvf菜܂B

    list.pop()\bh͈͎̔włłB
    :type L: list
    :type s: slice
    :rtype: list
    """
    if isinstance(s, int):
        return L.pop(int)
    else:
        t = L[s]
        del L[s]
        return t


def countsToSlices(counts):
    u"""JEgXgXCXXg܂.

    [3, 4, 5] >> [slice(0, 3), slice(3, 7), slice(7, 12)]

    :rtype: list of slice
    """
    if not counts:
        return []

    slices = []
    append = slices.append
    s = 0
    for c in counts:
        e = s + c
        append(slice(s, e))
        s = e

    return slices


def countsToRanges(counts):
    u"""JEgXg͈̓Xg܂.

    [3, 4, 5] >> [[0, 1, 2], [3, 4, 5, 6], [7, 8, 9, 10, 11]]

    :rtype: list of list
    """
    if not counts:
        return []

    ranges = []
    append = ranges.append
    s = 0
    for c in counts:
        e = s + c
        append(range(s, e))
        s = e

    return ranges


def avg(iterable):
    u"""l̕ϒl擾܂B

    :param iterable: len֐Ȃꍇ͎IɃ^vɕϊ܂B
                     evf͉Z'ł̏Z'ɑΉKv܂B
    :return: iterable̐擪vfƓNX̃IuWFNgB
             vf0ꍇNoneԂ܂B
    """
    if not hasattr(iterable, "__len__"):
        iterable = tuple(iterable)

    it = iter(iterable)
    try:
        val = it.next()
        for v in it:
            val = val + v
        return val / len(iterable)
    except StopIteration:
        return None


def removeOverlap(iterable):
    u"""iterabled菜Xg擾܂B

    setƈႢiterableŎ擾ۏ؂܂B
    :rtype: list
    """

    itemSet = set()
    L = []
    addToSet = itemSet.add
    addToList = L.append
    for item in iterable:

        if not item in itemSet:
            addToSet(item)
            addToList(item)

    return L


def keysToDict(**keys):
    u"""̃L[[hɃpbN܂B"""

    return keys


def isTypeOf(obj, types):
    u"""IuWFNg̃^CvɃ`FbN܂B

    isinstance͔h^Cvɂ}b`܂Ã\bh͑S^Cv
    }b`܂B
    :param obj: `FbNΏۂ̃IuWFNgB
    :param types: ^Cv܂̓^CṽXgB
    :type types: class or type or tuple or list
    :rtype: bool
    """
    if not isinstance(types, (tuple, list)):
        types = (types,)

    objType = type(obj)
    for t in types:
        if objType == t:
            return True

    return False
