# -*- coding: shift-jis -*-
import pymel.core as pm


def getLangStr():
    """Get the current language string.

    :rtype: str
    """
    return pm.about(uiLanguage=True)


def getLangFrom(langStr):
    """Get the texts class.

    :param str langStr: The maya style language text.
    :rtype: English or derived
    """
    if langStr == 'ja_JP':
        return Japanese
    else:
        return English


def getCurrentLang():
    """Get the texts class in the current language setting.

    :rtype: English or derived
    """
    return getLangFrom(getLangStr())


class English(object):

    labelWidth = 80
    valueWidth = 108
    title = u"PmxIO for Maya"
    ready = u"Ready"
    close = u"Close"
    second = u"sec"

    class ImportTab(object):
        label = u"Import"

        class General(object):
            label = u"General"
            sepMesh = u"Separate Mesh by Materials."
            createGrp = u"Create Group"
            grpName = u"Group Name:"
            createNs = u"Create Namespace"
            nsName = u"NS Name:"
            scale = u"Scale:"

        class Bone(object):
            label = u"Bone"
            jSize = u"Joint Size:"

        class Texture(object):
            label = u"Texture"
            connectAlpha = u"Connect Alpha Channel"

    class ExportTab(object):
        label = u"Export"

        class General(object):
            label = u"General"
            removeNS = u"Remove Namespace"
            scale = u"Scale:"

        class Bone(object):
            label = u"Bone"
            target = u"Include Joints"
            targetTree = u"Influence Joint Tree"
            targetInf = u"Only Influence Joint"
            display = u"Display Destination"
            displayNone = u"None"
            displaySingle = u"Single Child"
            displayAvg = u"Average Position"

        class Texture(object):
            label = u"Texture"
            render = u"Render Textures"
            format = u"Format:"
            size = u"Max Size:"
            scale = u"Scale:"
            overlap = u"File Overlap"
            force = u"Overwrite"
            rename = u"Rename"
            skip = u"Skip"
            png = u"PNG (with Alpha)"
            jpg = u"JPEG"
            tga = u"TGA"
            bmp = u"BMP"

        class Morph(object):
            label = u"Morph (Beta)"
            enable = u"Enable"
            space = u"Space:"
            object = u"Object"
            world = u"World"
            enableSet = u"Enable MorphSet"

    class Importer(object):
        started = u"Import Started."
        createMesh = u"Creating Meshes..."
        createSkelton = u"Creating Skelton..."
        createSkin = u"Creating Smooth Skin..."
        createMaterial = u"Creating Materials..."
        completed = u"Import Completed."
        boneParentErr = u"Invalid parent bone. Setting skipped."
        parentId = u"ParentID"

    class Exporter(object):
        started = u"Export Started."
        meshFrom = u"Read Mesh: "
        createModel = u"Creating Model..."
        renderTexture = u"Rendering: "
        textureName = u"Texture: u"
        writeToFile = u"Writing to File..."
        completed = u"Export Completed."


class Japanese(English):

    labelWidth = 90
    valueWidth = 120
    close = u""
    second = u"b"

    class ImportTab(English.ImportTab):
        label = u"C|[g"

        class General(English.ImportTab.General):
            label = u"S"
            sepMesh = u"}eAŃtF[X𕪊"
            createGrp = u"O[v"
            grpName = u"O[v:"
            createNs = u"l[Xy[X̎gp"
            nsName = u"l[Xy[X:"
            scale = u"XP[:"

        class Bone(English.ImportTab.Bone):
            label = u"{["
            jSize = u"WCgTCY:"

        class Texture(English.ImportTab.Texture):
            label = u"eNX`"
            connectAlpha = u"At@ڑ"

    class ExportTab(English.ExportTab):
        label = u"GNX|[g"

        class General(English.ExportTab.General):
            label = u"S"
            removeNS = u"l[Xy[X̏"
            scale = u"XP[:"

        class Bone(English.ExportTab.Bone):
            label = u"{["
            target = u"ΏۃWCg"
            targetTree = u"֘AWCgc["
            targetInf = u"CtGX̂"
            display = u"\"
            displayNone = u"ݒ肵Ȃ"
            displaySingle = u"q1̎̂"
            displayAvg = u"q̕ύW"

        class Texture(English.ExportTab.Texture):
            label = u"eNX`"
            render = u"eNX`_O"
            format = u"`:"
            png = u"PNG@(At@t)"
            jpg = u"JPG"
            tga = u"TGA"
            bmp = u"BMP"
            size = u"𑜓x:"
            scale = u"XP[:"
            overlap = u"dt@C"
            force = u"㏑ۑ"
            rename = u"ʖŕۑ"
            skip = u"ۑȂ"

        class Morph:
            label = u"[t (Beta)"
            enable = u"Lɂ"
            space = u"Xy[X:"
            object = u"IuWFNg@@@@@@"
            world = u"[h@@@@@@"
            enableSet = u"[tZbggp"

    class Importer(English.Importer):
        started = u"C|[gJn܂B"
        createMesh = u"bV쐬Ă܂"
        createSkelton = u"XPg쐬Ă܂B"
        createSkin = u"X[XXL쐬Ă܂B"
        createMaterial = u"}eA쐬Ă܂B"
        completed = u"C|[g܂B"
        boneParentErr = (u"{[eQƂsłB" +
                         u"ݒXLbv܂B")
        parentId = u"eID"

    class Exporter(English.Exporter):
        started = (u"GNX|[gJn܂B\r\n" +
                   u"bV擾Ă܂B")
        meshFrom = u"Read Mesh: "
        createModel = u"f쐬Ă܂B"
        renderTexture = u"eNX`xCNĂ܂B"
        textureName = u"Texture: "
        writeToFile = u"t@CɕۑĂ܂B"
        completed = u"GNX|[g܂B"
