# -*- coding: shift-jis -*-
import re
import traceback
import pymel.core as pm
import pymel.core.nodetypes as nt
import pymel.core.uitypes as ui
import os.path as ospath
import pmxio

from pmxio.trutils import keysToDict
from pmxio.trutils.string import getUnicode
from pmxio.trutils.maya import filterTransform
from pmxio.trutils.maya.ui import createBasicWindow
from pmxio.language import getLangStr, getLangFrom, getCurrentLang
from pmxio import importer, exporter
from pmxio.pymeshio import common
from pmxio.setting import ImportSetting, ExportSetting
from pmxio.trutils.collection._uniquelist import UniqueList

# 萔
IMP_FILTER = "MMD Model File (*.pmx *.pmd);;All File (*.*)"
EXP_FILTER = "MMD Model File (*.pmx);;All File (*.*)"
SEPARATOR_LENGTH = 48
MAX_PRECISION = 12


class PanelCommon(object):

    def indent(self, enable=True):
        u"""Cfgspl擾܂.

        :rtype: ui.ColumnLayout
        """

        form = ui.FormLayout()
        with form:
            col = ui.ColumnLayout(adj=True, en=enable)

        form.attachForm(col, "top", 0)
        form.attachForm(col, "left", 16)
        form.attachForm(col, "right", 0)
        form.attachForm(col, "bottom", 0)

        return col

    def frame(self, label):
        u"""xtt[擾܂.

        :rtype: ui.ColumnLayout
        """

        with ui.FrameLayout(l=label, mw=14, mh=14, cll=True):
            col = ui.ColumnLayout(adj=True)

        return col

    def template(self, labelWidth, valueWidth):
        u"""ʂ̃ev[g擾܂.

        :rtype: ui.UITemplate
        """

        t = ui.UITemplate()
        t.define(pm.columnLayout, adj=True, rs=3)
        t.define(pm.separator, st="none", h=4)
        t.define(pm.text, al="left", fn="boldLabelFont", h=20)

        kw = keysToDict(cal=(1, "left"), cw2=(labelWidth, valueWidth))
        t.define(pm.floatFieldGrp, **kw)
        t.define(pm.intFieldGrp, **kw)
        t.define(pm.optionMenuGrp, **kw)
        t.define(pm.textFieldGrp, adj=2, **kw)

        return t

    def setFloatFieldValue(self, field, value):
        u"""FloatFieldlύXCxg.

        valuȅ_ȉɂ, IFloatFielďg܂.
        """
        prec = min(len(str(value).split(".")[-1]), MAX_PRECISION)
        field.precision(prec)
        field.setValue1(value)

    def setCheckBoxValue(self, cb, value):
        u"""`FbN{bNX̒lݒ肵܂.

        `FbN{bNXeffectvpeBĂꍇ,
        effectɐݒ肳ꂽR|[lgEnablelɐݒ肵܂.
        """
        cb.setValue(value)
        if hasattr(cb, "effect"):
            comp = getattr(cb, "effect")
            comp.setEnable(value)

    def getRadioCollectionIndex(self, rc):
        u"""WIRNVIĂCfbNX擾܂.

        CfbNX1JnlɂȂ܂.

        :rtype: int
        """
        # getCollect  unicodeԂ
        for index, rb in enumerate(rc.getCollectionItemArray(), 1):
            if pm.radioButton(rb, q=True, sl=True):
                return index
        return -1

    def setRadioCollectionIndex(self, rc, index):
        u"""CfbNXw肵ăWI{^I܂.

        CfbNX1JnlɂȂ܂.
        """
        # getCollect  unicodeԂ
        items = rc.getCollectionItemArray()
        index -= 1
        try:
            pm.radioButton(items[index], e=True, sl=True)
        except:
            for item in items:
                pm.radioButton(item, e=True, sl=False)


class ImportPanel(ui.ColumnLayout, PanelCommon):

    def __new__(cls, lang, **kw):
        return ui.ColumnLayout.__new__(cls, **kw)

    def __init__(self, lang, **kw):

        # f[^擾
        if lang is None:
            lang = getCurrentLang()
        gen = lang.ImportTab.General
        bone = lang.ImportTab.Bone
        tex = lang.ImportTab.Texture

        # eCAEg
        ui.ColumnLayout.__init__(self)
        self.adjustableColumn(True)

        with self:
            with self.template(lang.labelWidth, lang.valueWidth):

                # uŚvt[
                with self.frame(gen.label):
                    self.sepMeshCB = ui.CheckBox(l=gen.sepMesh)
                    ui.Separator()

                    self.createGrpCB = ui.CheckBox(l=gen.createGrp)
                    with self.indent():
                        self.grpNameTF = ui.TextFieldGrp(l=gen.grpName)
                    self.createGrpCB.effect = self.grpNameTF
                    ui.Separator()

                    self.createNsCB = ui.CheckBox(l=gen.createNs)
                    with self.indent():
                        self.nsNameTF = ui.TextFieldGrp(l=gen.nsName)
                    self.createNsCB.effect = self.nsNameTF
                    ui.Separator()

                    self.scaleFF = ui.FloatFieldGrp(l=gen.scale)

                # u{[vt[
                with self.frame(bone.label):
                    self.boneJSizeFF = ui.FloatFieldGrp(l=bone.jSize)

                # ueNX`vt[
                with self.frame(tex.label):
                    self.texConnectAlpha = ui.CheckBox(l=tex.connectAlpha)

        # Cxgnhݒ
        self.createGrpCB.setChangeCommand(pm.CallbackWithArgs(self.setCheckBoxValue, self.createGrpCB))
        self.createNsCB.setChangeCommand(pm.CallbackWithArgs(self.setCheckBoxValue, self.createNsCB))
        self.scaleFF.changeCommand(pm.CallbackWithArgs(self.setFloatFieldValue, self.scaleFF))
        self.boneJSizeFF.changeCommand(pm.CallbackWithArgs(self.setFloatFieldValue, self.boneJSizeFF))

        # f[^ݒ
        self.setDefault()

    def setDefault(self):
        u"""ftHglݒ"""

        self.sepMeshCB.setValue(True)
        self.setCheckBoxValue(self.createGrpCB, True)
        self.grpNameTF.setText("")
        self.setCheckBoxValue(self.createNsCB, False)
        self.nsNameTF.setText("")
        self.setFloatFieldValue(self.scaleFF, 1.0)
        self.setFloatFieldValue(self.boneJSizeFF, 0.25)
        self.texConnectAlpha.setValue(False)

    def getSetting(self):
        u"""C^tF[XSẴp[^擾܂.

        :rtype: ImportSetting
        """
        s = ImportSetting()
        s.separateMesh = self.sepMeshCB.getValue()
        s.createGrp = self.createGrpCB.getValue()
        s.grpName = self.grpNameTF.getText()
        s.createNs = self.createNsCB.getValue()
        s.nsName = self.nsNameTF.getText()
        s.scale = self.scaleFF.getValue1()
        s.jointSize = self.boneJSizeFF.getValue1()
        s.connectAlpha = self.texConnectAlpha.getValue()

        return s


class ExportPanel(ui.ColumnLayout, PanelCommon):

    def __new__(cls, lang, **kw):
        return ui.ColumnLayout.__new__(cls, **kw)

    def __init__(self, lang, **kw):
        u"""

        :
            eڂEnable ON/OFF͎Abvf[gŎ.
        """

        # f[^擾
        if lang is None:
            lang = getCurrentLang()
        gen = lang.ExportTab.General
        bone = lang.ExportTab.Bone
        tex = lang.ExportTab.Texture
        morph = lang.ExportTab.Morph

        # eCAEg
        ui.ColumnLayout.__init__(self, **kw)
        self.adjustableColumn(True)

        with self:
            with self.template(lang.labelWidth, lang.valueWidth):
                # uŚvt[
                with self.frame(gen.label):
                    self.removeNsCB = ui.CheckBox(l=gen.removeNS)
                    ui.Separator()
                    self.scaleFF = ui.FloatFieldGrp(l=gen.scale)

                # u{[vt[
                with self.frame(bone.label):
                    ui.Text(l=bone.target)
                    with self.indent():
                        self.boneTargetRC = ui.RadioCollection()
                        ui.RadioButton(l=bone.targetTree)
                        ui.RadioButton(l=bone.targetInf)
                    ui.Separator()
                    ui.Text(l=bone.display)
                    with self.indent():
                        self.boneDisplayRC = ui.RadioCollection()
                        ui.RadioButton(l=bone.displayNone)
                        ui.RadioButton(l=bone.displaySingle)
                        ui.RadioButton(l=bone.displayAvg)
                    ui.Separator()

                # ueNX`vt[
                with self.frame(tex.label):

                        self.texRenderCB = ui.CheckBox(l=tex.render)
                        ui.Separator()
                        self.texRenderLayout = self.indent()
                        self.texRenderCB.effect = self.texRenderLayout
                        with self.texRenderLayout:

                            # _Op[^ݒ
                            self.texFormatOM = ui.OptionMenuGrp(l=tex.format)
                            with self.texFormatOM:
                                ui.MenuItem(l=tex.png)
                                ui.MenuItem(l=tex.jpg)
                                ui.MenuItem(l=tex.tga)
                                ui.MenuItem(l=tex.bmp)
                            self.texSizeIF = ui.IntFieldGrp(l=tex.size)
                            self.texScaleFF = ui.FloatFieldGrp(l=tex.scale)
                            ui.Separator()

                            # t@C㏑ۑݒ
                            ui.Text(l=tex.overlap)
                            with self.indent():
                                self.texOverlapRC = ui.RadioCollection()
                                ui.RadioButton(l=tex.force)
                                ui.RadioButton(l=tex.rename)
                                ui.RadioButton(l=tex.skip)

                # u[tvt[
                with self.frame(morph.label):
                    self.morphEnableCB = ui.CheckBox(l=morph.enable)
                    ui.Separator()
                    with self.indent() as self.morphLayout:
                        self.morphEnableSetCB = ui.CheckBox(l=morph.enableSet)
                        ui.Separator()
                        self.morphSpaceOM = ui.OptionMenuGrp(l=morph.space)
                        with self.morphSpaceOM:
                            ui.MenuItem(l=morph.object)
                            ui.MenuItem(l=morph.world)
                    self.morphEnableCB.effect = self.morphLayout

        # Cxgnhݒ
        for cb in (self.texRenderCB, self.morphEnableCB):
            cb.setChangeCommand(pm.CallbackWithArgs(self.setCheckBoxValue, cb))
        for ff in (self.scaleFF, self.texScaleFF):
            ff.changeCommand(pm.CallbackWithArgs(self.setFloatFieldValue, ff))

        self.setDefault()

    def setDefault(self):
        u"""ftHglݒ"""

        self.removeNsCB.setValue(True)
        self.setFloatFieldValue(self.scaleFF, 1.0)
        self.setRadioCollectionIndex(self.boneTargetRC, 1)
        self.setRadioCollectionIndex(self.boneDisplayRC, 2)
        self.setCheckBoxValue(self.texRenderCB, False)
        self.texFormatOM.setSelect(1)
        self.texSizeIF.setValue1(1024)
        self.setFloatFieldValue(self.texScaleFF, 1.0)
        self.setRadioCollectionIndex(self.texOverlapRC, 2)
        self.setCheckBoxValue(self.morphEnableCB, False)
        self.morphSpaceOM.setSelect(2)
        self.morphEnableSetCB.setValue(False)

    def getSetting(self):
        u"""C^tF[XSẴp[^擾܂.

        :rtype: ExportSetting
        """
        s = ExportSetting()
        s.removeNs = self.removeNsCB.getValue()
        s.scale = self.scaleFF.getValue1()
        s.boneTargetMode = self.getRadioCollectionIndex(self.boneTargetRC)
        s.boneTailMode = self.getRadioCollectionIndex(self.boneDisplayRC)
        s.morphExport = self.morphEnableCB.getValue()
        s.morphExportSet = self.morphEnableSetCB.getValue()
        s.morphSpace = self.morphSpaceOM.getSelect()
        s.texExport = self.texRenderCB.getValue()
        s.texFormat = self.texFormatOM.getSelect()
        s.texMaxSize = self.texSizeIF.getValue1()
        s.texScale = self.texScaleFF.getValue1()
        s.texWriteMode = self.getRadioCollectionIndex(self.texOverlapRC)

        return s


class MainWindow(object):
    u"""PMXIOCEBhENXB"""

    def __init__(self, langStr=None):
        u"""CEBhE܂."""

        # f[^̎擾
        if not langStr:
            langStr = getLangStr()
        self.language = lang = getLangFrom(langStr)

        # EBhEݒ
        self.version = pmxio.__version__
        self.title = "%s (ver%s)" % (lang.title, self.version)
        self.lastDirectory = pm.Workspace.getPath()
        self.putOnScriptEditor = True
        panePercent = 80

        # {EBhE쐬
        res = createBasicWindow(width=400, height=620, title=self.title,
                                buttonTexts=(lang.ImportTab.label, lang.close))
        self.window = res[0]
        self.runBtn = res[2][0]
        layout = res[1]
        closeBtn = res[2][1]

        # CAEg쐬
        with ui.PaneLayout(p=layout, cn="horizontal2") as paneLayout:
            self.tabLayout = ui.TabLayout(tv=True)
            with self.tabLayout:
                with ui.ScrollLayout(cr=True) as importTab:
                    self.importPanel = ImportPanel(lang)
                with ui.ScrollLayout(cr=True) as exportTab:
                    self.exportPanel = ExportPanel(lang)
            self.textField = ui.ScrollField(ed=False)

        paneLayout.setPaneSize((1, 100, panePercent))
        self.tabLayout.setTabLabel((importTab, lang.ImportTab.label))
        self.tabLayout.setTabLabel((exportTab, lang.ExportTab.label))

        # Cxgnhݒ ------------------------------------------------
        self.tabLayout.setSelectCommand(self.tabLayout_Changed)
        closeBtn.setCommand(self.closeBtn_Clicked)
        self.runBtn.setCommand(pm.Callback(self.runBtn_Clicked))

        self.putMsg("%s %s" % (self.title, lang.ready))
        self.window.show()

    def putMsg(self, msg, isWarning=False):
        u"""ibZ[W\܂."""

        # ieLXgtB[hɒǉ
        self.textField.insertText(msg + "\n")
        pm.refresh()

        # XNvgGfB^ɂo͂邩
        if isWarning:
            pm.warning(msg)
        elif self.putOnScriptEditor:
            print msg

    def runImport(self):
        u"""t@C_CAO\ǂݍݏJnB"""

        # t@CI_CAO
        result = pm.fileDialog2(ds=2, fm=1, ff=IMP_FILTER,
                                dir=self.lastDirectory)
        if not result:
            return

        path = getUnicode(result[0])
        self.lastDirectory = ospath.dirname(path)

        # C^tF[Xp[^擾
        setting = self.importPanel.getSetting()

        # C|[gJn
        self.putMsg("-" * SEPARATOR_LENGTH)
        self.putMsg(u">> " + ospath.basename(path))
        importer.run(path, setting, self.putMsg)

    def runExport(self):
        u"""t@C_CAO\ǂݍݏJnB"""

        # bV̑I擾
        transes = filterTransform(pm.selected(tr=True, dag=True), nt.Mesh)
        transes = UniqueList(transes)
        if not transes:
            msg = u"LȃbVIĂ܂B"
            self.putMsg(msg, True)
            return

        # t@Cۑ_CAO
        result = pm.fileDialog2(ds=2, fm=0, ff=EXP_FILTER,
                                dir=self.lastDirectory)
        if not result:
            return

        # t@CpX擾
        path = getUnicode(result[0])
        self.lastDirectory = ospath.dirname(path)
        if not re.search("\\.pmx$", path):
            path += ".pmx"

        # C^tF[Xp[^擾
        setting = self.exportPanel.getSetting()

        # GNX|[gJn
        self.putMsg("-" * SEPARATOR_LENGTH)
        self.putMsg(u">> " + ospath.basename(path))
        exporter.run(path, transes, setting, self.putMsg)

    #  EventHandlers --------------------------------------------------------

    def tabLayout_Changed(self):
        if self.tabLayout.getSelectTabIndex() == 1:
            label = self.language.ImportTab.label
        else:
            label = self.language.ExportTab.label
        self.runBtn.setLabel(label)

    def runBtn_Clicked(self, *args):
        try:
            pm.undoInfo(openChunk=1)
            if self.tabLayout.getSelectTabIndex() == 1:
                self.runImport()
            else:
                self.runExport()

        except Exception as e:
            # Oߑ
            put = lambda x: self.putMsg(x, True)
            put(u"G[܂B-------------------------------------")
            put(u"Ver : " + str(self.version))
            put(u"Lang: " + str(self.language.__class__))

            # g[XobÑpX菜
            subFunc = lambda x: "File \"" + ospath.basename(x.group(0))
            trace = re.sub("File \".+?\"", subFunc, traceback.format_exc())

            put(trace)
            if e.message == "not implemented GroupMorph":
                put(u"MeshIOCu̓O[v[tɑΉĂ܂B")
                put(u"O[v[t폜čēxǂݍ݂sĂB")
            elif e.message == "not implemented UvMorph":
                put(u"MeshIOCuUV[tɑΉĂ܂B")
                put(u"UV[t폜čēxǂݍ݂sĂB")
            elif isinstance(e, common.ParseException):
                put(u"MeshIOCuPMX/PMDt@C" +
                    u"ΉĂȂ\܂B")
            put(u"------------------------------------------------------")

        finally:
            pm.undoInfo(closeChunk=1)

    def closeBtn_Clicked(self, *args):
        self.window.delete()


def test():
    MainWindow(langStr="ja_JP")


# test()
