# -*- coding: shift-jis -*-
u"""PMXeNX`̃W[.

TextureFactory(object)
    Texture𐶐t@NgNX.
    render()create()ɂăm[hCX^X𐶐鎖
    o܂.

Texture(object)
    eNX`̃f[^NX.

Size(object)
    x, yl݂̂Ȉ2DTCYNX.

WriteModes(object)
    eNX`t@Cۑ[h̒萔NX.

TextureFormats(object)
    eNX`tH[}bg̒萔NX.
    萔Ɗgq𑊌݂ɕϊ@\.
"""

import shutil
import os.path as ospath
import pymel.core as pm
import pymel.core.nodetypes as nt

import pmxio.trutils as trutils
import pmxio.trutils.path as pathutils
from pmxio.trutils.decorator import memonode


# Limit of texture resolution in this module.
MAX_RESOLUTION = 4096


class TextureFactory(object):

    def __init__(self, direc, useRender=False, renFmt=None, maxSize=None,
                 scale=None, writeMode=None, msgCallback=(lambda m, w: _)):
        u"""eNX`t@Ng܂.

        :param str direc: GNX|[gfBNg.
        :param bool useRender: _Os.
        :param int renFmt: ۑtH[}bg. (TextureFormats)
        :param Size maxSize: ۑ𑜓x.
                             Filem[h̃eNX`̉𑜓xȉȂ,
                             IWỉ𑜓x̂܂܎gp܂.
        :param float scale: ŏIXP[l.
                            maxSizeŐݒ肵𑜓xɏZ܂.
        :param int writeMode: ۑ̃t@Č@. (WriteModes)
        :param function msgCallback: ibZ[W̃R[obN֐.

        :return: _OEۑɐTextureIuWFNgԂ܂.
                 sꍇ, NoneԂ܂.
        :rtype: Texture or None
        """

        self._cache = {}
        self._directory = direc
        self._useRender = useRender
        self._renderFormat = renFmt
        self._renderMaxSize = maxSize
        self._renderScale = scale
        self._renderWriteMode = writeMode
        self._msgCallback = msgCallback

    @property
    def instances(self):
        u"""̃t@NgŐCX^Xƃm[h̎.

        :rtype: dict
        :returns: m[hL[, CX^XlɎ.
        """
        return self._cache

    def _getRenderPath(self, direc, name, fmt, mode):
        u"""_ÕtpX擾܂.

        >>> f = TextureFactory()
        >>> jpg = TextureFormats.JPG
        >>> mode = WriteModes.OVERWRITE
        >>> f._getRenderPath("c:/export/", "abc", jpg, mode)
        ('c:/export/abc.jpg', False)

        :rtype: (str, bool)
        :returns: (path, skipped)
        """
        ext = TextureFormats.toString(fmt)
        path = "%s.%s" % (ospath.join(direc, name), ext)

        # Already file exists.
        if ospath.isfile(path):
            if mode == WriteModes.SKIP:
                return (path, True)
            elif mode == WriteModes.RENAME:
                path = pathutils.getUniqueName(path)

        return (path, False)

    def _getRenderSize(self, size, maxSize, scale):
        u"""_O̍ŏITCY擾܂.

        >>> f = TextureFactory()
        >>> f._getRenderSize(Size(1024, 512), 512, 0.5)
        Size(256, 128)
        >>> f._getRenderSize(Size(512, 512), 1024, 1.0)
        Size(512, 512)

        :rtype: Size
        """
        x = max(1, size.x)
        y = max(1, size.y)
        r = maxSize / float(max(x, y, maxSize))
        sx = trutils.between(1, int(x * r * scale), MAX_RESOLUTION)
        sy = trutils.between(1, int(y * r * scale), MAX_RESOLUTION)

        return Size(sx, sy)

    def _getFileNodeDatas(self, node):
        u"""Filem[hf[^擾܂."""

        path = node.fileTextureName.get()
        size = Size(*node.outSize.get())
        alpha = node.fileHasAlpha.get()

        return (path, size, alpha)

    def _isEnableTexture(self, path):
        u"""LȃeNX`t@CȂ^Ԃ܂.

        :rtype: bool
        """
        fmt = TextureFormats.fromString(path)
        return ospath.isfile(path) and fmt != TextureFormats.UNKNOWN

    def _normPath(self, path):
        """:rtype: str"""
        return ospath.normcase(ospath.normpath(path))

    def _getRelativePath(self, dirPath, texPath):
        u"""o͐fBNg̑΃pX擾܂.

        texPathdirPath̉ʃfBNgȂ, ΃pXԂ܂.
        łȂΐ΃pXԂ܂.

        >>> f = TextureFactory()
        >>> f._getRelativePath("c:/export/", "c:/export/abc.jpg")
        u'abc.jpg'

        >>> f._getRelativePath("c:/export/", "e:/other/baz.jpg")
        u'e:/other/baz.jpg'

        :param str dirPath: o͐fBNg̃pX.
                            ΃pXꍇ, MayavWFNg̃[g
                            tH_ɂ܂.

        :param str texPath: eNX`pX.
                            ΃pẌdirPathƓł.
        :rtype: unicode
        """
        if not texPath:
            return ""
        schars = "\\\/"
        dirPath = self._normPath(pm.workspace(en=dirPath.strip(schars)))
        texPath = self._normPath(pm.workspace(en=texPath.strip(schars)))
        cmnPath = self._normPath(ospath.commonprefix((dirPath, texPath)))

        if dirPath == cmnPath:
            return unicode(self._normPath(ospath.relpath(texPath, dirPath)))
        else:
            return unicode(texPath)

    def _render(self, node):
        u"""m[h_OăeNX`𐶐܂.

        m[hFile, eNX`eɕύX΃eNX`̂܂
        Rs[Ĕzu܂.

        :param DependNode node: _OΏۂ̃m[h.
        """

        # _O
        direc = self._directory
        expFmt = self._renderFormat
        maxSize = self._renderMaxSize
        scale = self._renderScale
        writeMode = self._renderWriteMode

        # _OɕKvȃf[^W
        if isinstance(node, nt.File):

            # Filem[h
            texPath, texSize, texAlpha = self._getFileNodeDatas(node)
            texName = ospath.splitext(ospath.basename(texPath))[0]
            texFmt = TextureFormats.fromString(texPath)

        elif isinstance(node, nt.DependNode):

            # ̑SẴm[h
            texPath = ""
            texSize = Size(maxSize, maxSize)
            texAlpha = False
            texName = node.nodeName().split(":")[-1]
            texFmt = TextureFormats.UNKNOWN
        else:
            return None

        # pX擾
        expPath, skip = self._getRenderPath(direc, texName, expFmt, writeMode)
        relPath = self._getRelativePath(direc, expPath)

        # XLbvꍇ
        if skip or texPath == expPath:
            # ɂt@CTexture쐬
            return Texture(relPath, texAlpha)

        try:
            # \[XeNX`Rs[\
            if (ospath.isfile(texPath) and max(texSize) <= maxSize and
                    scale == 1.0 and texFmt == expFmt):

                shutil.copy(texPath, expPath)
                return Texture(relPath, texAlpha)
            else:
                # m[h_O
                expSize = self._getRenderSize(texSize, maxSize, scale)
                expExt = TextureFormats.toString(expFmt)

                r = pm.convertSolidTx(node, antiAlias=True, samplePlane=True,
                                      alpha=texAlpha, fileFormat=expExt,
                                      fin=expPath, rx=expSize.x, ry=expSize.y)
                pm.delete(r)
                return Texture(relPath, texAlpha)
        except:
            pass

        return None

    @memonode
    def create(self, node):
        u"""m[hTextureCX^X쐬܂.

        _Ogp[h̏ꍇ, Kvɉă_Os܂.
        ̃\bhnodeL[ƂăLbV܂.
        ȍ~, m[hō쐬݂ꍇ, ̃CX^XԂ悤
        Ȃ܂.

        :param DependNode node: Ώۂ̃m[h.

        :return: 쐬Ɏsꍇ, NoneԂ܂.
        :rtype: Texture or None
        """

        if self._useRender:
            # _O[h
            self._msgCallback(u"Render: " + str(node))
            return self._render(node)

        else:
            # ʏ̍쐬[h
            if isinstance(node, nt.File):
                texPath, _, texAlpha = self._getFileNodeDatas(node)
                relPath = self._getRelativePath(self._directory, texPath)
                if self._isEnableTexture(texPath):
                    return Texture(relPath, texAlpha)

        return None


class Size(object):
    u"""Ȉ2DTCYNX."""

    def __init__(self, x=0.0, y=0.0):
        self.x = x
        self.y = y

    def __iter__(self):
        yield self.x
        yield self.y

    def __str__(self):
        return "Size(%d, %d)" % (self.x, self.y)

    def __repr__(self):
        return self.__str__()

    def __eq__(self, other):
        return self.x == other.x and self.y == other.y

    def __ne__(self, other):
        return not self.__eq__(other)


class WriteModes(object):
    u"""t@Cۑ[h̒萔NX.

    :var OVERWRITE: Ƀt@Cꍇ, ㏑ۑ܂.
    :var RENAME: Ƀt@Cꍇ, IɐVO쐬܂.
    :var SKIP: Ƀt@Cꍇ, ۑXLbv܂.
    """

    OVERWRITE = 1
    RENAME = 2
    SKIP = 3


class TextureFormats(object):
    u"""eNX``̒萔NX."""

    PNG = 1
    JPG = 2
    TGA = 3
    BMP = 4

    UNKNOWN = 100

    @classmethod
    def fromString(cls, path):
        u"""񂩂萔擾܂.

        :param str path: gq܂ޕ.
        :rtype: int
        """
        ext = path.split(".")[-1].lower().strip()
        if ext == "png":
            return cls.PNG
        elif ext == "jpg" or ext == "jpeg":
            return cls.JPG
        elif ext == "tga":
            return cls.TGA
        elif ext == "bmp":
            return cls.BMP
        else:
            return cls.UNKNOWN

    @classmethod
    def toString(cls, value):
        u"""萔lgq擾܂.

        :rtype: str
        """
        if value == cls.PNG:
            return "png"
        elif value == cls.JPG:
            return "jpg"
        elif value == cls.TGA:
            return "tga"
        elif value == cls.BMP:
            return "bmp"
        else:
            return ""


class Texture(object):

    def __init__(self, path, hasAlpha=False):

        self._path = path
        self._hasAlpha = hasAlpha
        self.index = -1

    def __str__(self):
        return str(ospath.basename(self._path))

    def __repr__(self):
        return "Texture('%s')" % ospath.basename(self._path)

    @property
    def path(self):
        """:rtype: str"""
        return self._path

    @property
    def format(self):
        """:rtype: int"""
        return TextureFormats.fromString(self._path)

    @property
    def has_alpha(self):
        """:rtype: bool"""
        return self._hasAlpha

    def encode(self, enc):
        """:rtype: unicode"""
        return unicode(self._path).encode(enc)


if __name__ == "__main__":
    import doctest
    doctest.testmod()
