# -*- coding: shift-jis -*-
from pmxio.trutils.decorator import mproperty
u"""[t^[QbgW[.

 [tdll@

EP̃x[XbVƕ̃[tbVΉt
EΉt̓[tbVɃAgr[guMorphBasevŎw
E[tbV͓_łȂ΂ȂȂ
E[tbVZbgɓăO[v(O[v[tł͂Ȃ)
EUV[t͂ЂƂ܂
EV[̑SẴbV, Zbg`FbNKv

"""
import copy
import pymel.core as pm
import pymel.core.nodetypes as nt
from itertools import izip
from pmxio.utils import NodeObject
from pmxio.trutils.maya import filterTransform
from pmxio.pymeshio import pmx, common


class Spaces(object):

    INVALID = 0
    OBJECT = 1
    WORLD = 2

    @classmethod
    def toString(cls, value):
        """:rtype: str"""

        if value == cls.WORLD:
            return "world"
        elif value == cls.OBJECT:
            return "object"
        else:
            return ""

    @classmethod
    def fromString(cls, string):
        """:rtype: int"""

        if string == "world":
            return cls.WORLD
        elif string == "object":
            return cls.OBJECT
        else:
            return cls.INVALID


class PanelTypes(object):

    EYE_BROWS = 1
    EYES = 2
    MOUTH = 3
    OTHER = 4


class MorphTypes(object):

    GROUP = 0
    VERTEX = 1
    BONE = 2
    UV = 3
    UV1 = 4
    UV2 = 5
    UV3 = 6
    UV4 = 7
    MATERIAL = 8


def getMorphNodes(node):
    u"""w肵m[hɊ֘Atꂽ[tm[h擾܂.

    :type node: Transform
    :rtype: list of Transform
    """
    morphNodes = []
    append = morphNodes.append
    baseName = node.nodeName()
    numVerts = node.getShape().numVertices()

    for t in filterTransform(pm.ls(baseName + "*", tr=True), nt.Mesh):
        try:
            if t.nodeName() == baseName:  # gO
                continue
            if t.getShape().numVertices() == numVerts:
                append(t)
        except:
            pass

    return morphNodes


def getMorphs(meshData, removeNs=True, indexOffset=0,
              minOffset=0.001, space=Spaces.WORLD):
    u"""֘Atꂽ[t擾܂.

    :param MeshData meshData: x[XbVf[^.
    :param bool removeNs: l[Xy[X菜.
    :param int indexOffset: [tCfbNX̃ItZbgl.
    :param float minOffset: [tItZbg̍ŏl.
    :param int space: SpacesNX萔.
    :rtype: list of Morph
    """

    morphNodes = getMorphNodes(meshData.node)

    morphs = [Morph(n, meshData, removeNs, indexOffset, minOffset, space)
              for n in morphNodes]

    return morphs


def getMorphSets(morphs, removeNs=True):
    u"""morphsɎw肵[tɊ֘ASẴ[tZbg擾܂.

    :type morphs: list of Morph
    :param bool removeNs: l[Xy[X菜.
    :rtype: list of MorphSet
    """
    nodeToMorph = dict((m.node, m) for m in morphs)
    res = []

    for s in pm.ls(type="objectSet"):

        if (s.isRenderable() or
                s.name() == "defaultLightSet" or
                s.name() == "defaultObjectSet"):
            continue

        members = [nodeToMorph[n] for n in s.members(flatten=True)
                   if isinstance(n, nt.Transform) and n in nodeToMorph]
        if members:
            res.append(MorphSet(s, members, removeNs))

    return res


class Morph(pmx.Morph, NodeObject):
    u"""_[t̃NXł.

    :
        EIUV[tɂΉ.
          ̏ꍇ, ̃NXVertexMorphƂĕʂUVMorph.

    """

    def __init__(self, morphNode, baseMeshData, removeNs=True,
                 indexOffset=0, minOffset=0.001, space=Spaces.WORLD):
        u"""[tf[^܂.

        :param Transform morphNode: [tbVgXtH[.
        :param MeshData baseMeshData: x[XbṼf[^.
        :param int indexOffset: x[XbṼCfbNXItZbg.
        :param float minOffset: [tړ̍ŏl.
        :param int space: SpaceNX萔l.
        """

        # X[p[NX
        pmx.Morph.__init__(self,
                           name=u"`̃[t",
                           english_name="Unknown Morph",
                           panel=PanelTypes.OTHER,
                           morph_type=MorphTypes.VERTEX,
                           offsets=[])
        NodeObject.__init__(self, morphNode, removeNs)

        # bVf[^擾
        morphMesh = morphNode.getShape()
        morphPoints = morphMesh.getPoints(space=Spaces.toString(space))
        basePoints = baseMeshData.points
        basePointIds = baseMeshData.pointIds

        # x[XbVƃ[tbV̒_Xg
        offsets = [None] * len(basePoints)
        for i, (bp, p) in enumerate(izip(basePoints, morphPoints)):
            o = p - bp
            if o.length() >= minOffset:
                offsets[i] = common.Vector3(o[0], o[1], o[2] * -1)

        # _IDƂɓWJ
        append = self.offsets.append
        for i, pid in enumerate(basePointIds, indexOffset):
            o = offsets[pid]
            if o is not None:
                append(pmx.VertexMorphOffset(i, o))

    def merge(self, other):
        u"""selfother}[WV[t擾܂.

        }[Wׂɂ, self, otherɃCfbNXɂȂĂ
        Kv܂.

        :type other: Morph
        :rtype: Morph
        """

        selfOffsets = self.offsets
        othrOffsets = other.offsets

        # g̐󂢕쐬
        newInst = copy.copy(self)

        # ǂ炩̃XgȂKɏďI
        if not selfOffsets:
            newInst.offsets = list(othrOffsets)
            return newInst

        if not othrOffsets:
            newInst.offsets = list(selfOffsets)
            return newInst

        selfMinIdx = selfOffsets[0].vertex_index
        selfMaxIdx = selfOffsets[-1].vertex_index
        othrMinIdx = othrOffsets[0].vertex_index
        othrMaxIdx = othrOffsets[-1].vertex_index

        # self̑Ootherǉ
        if selfMinIdx > othrMaxIdx:
            newInst.offsets = othrOffsets + selfOffsets
            return newInst

        # self̌otherǉ
        if selfMaxIdx < othrMinIdx:
            newInst.offsets = selfOffsets + othrOffsets
            return newInst

        # dĂ͈͂
        offsets = selfOffsets + othrOffsets
        offsets.sort(key=lambda x: x.vertex_index)
        numOffsets = len(offsets)
        idx1 = 0
        idx2 = 1
        while idx2 < numOffsets:

            o1 = offsets[idx1]
            o2 = offsets[idx2]

            # f[^̏d
            if o1.vertex_index == o2.vertex_index:
                o1.position_offset += o2.position_offset
                del offsets[idx2]
                numOffsets -= 1

            idx1 += 1
            idx2 += 1

        newInst.offsets = offsets
        return newInst


class MorphSet(pmx.Morph, NodeObject):
    u"""̃[tZbgŊǗNX.

    :
    IɃAgr[g̎`d@\NodeObjectɎ̂Ōp
    Kv.

    """

    def __init__(self, objSet, morphs=[], removeNs=True):

        pmx.Morph.__init__(self,
                           name=u"`̕[t",
                           english_name="Unknown Morph Set",
                           panel=PanelTypes.OTHER,
                           morph_type=MorphTypes.VERTEX,
                           offsets=[])
        NodeObject.__init__(self, objSet, removeNs)
        self.morphs = morphs

    @mproperty
    def offsets(self):
        u"""}[WItZbg擾܂.

        ̃vpeB̓܂.
        """
        return self._mergeOffsets(self.morphs)

    @offsets.setter
    def offsets(self, val):
        # Dummy
        pass

    def _mergeOffsets(self, morphs):
        u"""̃[t}[WV[tItZbg쐬܂.

        [t1Ȃꍇ, ̃XgԂ܂.

        :rtype: list of MorphOffset
        """
        # Lȃ[t݂̂XgĂ
        morphs = [m for m in morphs if m.offsets]

        if len(morphs) == 0:
            return []

        # \vertex_index̍ŏlŃ\[gĂ
        # }[Wo\
        morphs.sort(key=lambda x: x.offsets[0].vertex_index)

        # [t1, ItZbgXg̐󂢃Rs[Ԃ
        resMorph = morphs[0]
        if len(morphs) == 1:
            return list(resMorph.offsets)

        # }[W
        for m in morphs[1:]:
            resMorph = resMorph.merge(m)

        return resMorph.offsets
