# -*- coding: shift-jis -*-
from pmxio.language import getCurrentLang
u"""GNX|[^̃bVf[^W[.

ExportSetting:
    GNX|[gݒf[^NX.

MeshData:
    |SbṼv~eBuȃf[^ǂݍރNX.
    Mesh̓ł̂ݎgp܂.
    ̑tF[X_ʂ̒_ɕ@\܂.

Mesh:
    ʂ̃bVf[^NX.
    PMXf[^͎ɂō쐬܂.

Model:
    Mesh1̃fɓZ߂NXł.

"""
from itertools import izip
from pmxio.pymeshio import pmx, common

from pmxio.utils import NodeObject
from pmxio.trutils import getGroupByCounts, getStairsByCounts, getGroupBy
from pmxio.trutils.collection import IndexedList
from pmxio.trutils.maya.skin import getSkinNode, getWeights, compressWeights
from pmxio.trutils.maya.render import getShadingGroups

from pmxio.exporter.material import MaterialFactory
from pmxio.exporter.bone import BoneFactory, BoneList
from pmxio.exporter.texture import TextureFactory
from pmxio.exporter.deformer import Bdef1, Bdef2, Bdef4
from pmxio.exporter.morph import getMorphs, getMorphSets


class MeshData(object):
    u"""v~eBuȃbVf[^̎擾sNX."""

    def __init__(self, trans, minSkinWeight):
        self.node = trans
        mesh = trans.getShape()
        res = self._getSeparatedIds(mesh)
        self.uvIds = res[0]
        self.pointIds = res[1]
        self.normalIds = res[2]
        self.triangles = res[3]
        self.joints, self.weights = self._getSkinWeights(mesh, minSkinWeight)
        self.uValues, self.vValues = mesh.getUVs()
        self.normals = mesh.getNormals(space="world")
        self.points = mesh.getPoints(space="world")
        self.numPoints = len(self.points)
        self.shadingEngines, self.sgFaceIds = getShadingGroups(trans)

    def _getSkinWeights(self, mesh, minSkinWeight):
        u"""bVXLEFCgl擾܂.

        :param Mesh mesh: MeshVFCvm[h.
        :param float skinMinWeight: LȃEFCg̍ŏl.
        :rtype: (list, list)
        :returns: (joints, weights)
        """
        skin = getSkinNode(mesh)
        if skin:
            normalize = True
            maxInf = 4
            joints, w = getWeights(mesh)
            weights = compressWeights(w, mesh.numVertices(), maxInf,
                                                minSkinWeight, normalize)
            return (joints, weights)
        else:
            return ([], [])

    def _getVtxFaceIds(self, mesh):
        u"""_ɓWJ_tF[X擾܂.

        :rtype: list
        :returns:
        [
            [(vtxId, faceId, uvId, normalId), (2ڂ̒_tF[X), ...],
            [2ڂ̒_],
            ...
        ]
        """
        # bVf[^擾
        vtxCounts, vtxIds = mesh.getVertices()
        uvIds = mesh.getAssignedUVs()[1]
        normalIds = mesh.getNormalIds()[1]
        faceIds = getStairsByCounts(vtxCounts)

        # _f[^i[p̃Xg
        vtxFaceData = [[] for _ in xrange(mesh.numVertices())]
        appends = [vf.append for vf in vtxFaceData]  # p

        # XgɑSĂ̒_f[^ݒ肷
        for vi, fi, uvi, ni in izip(vtxIds, faceIds, uvIds, normalIds):
            appends[vi]((vi, fi, uvi, ni))

        return vtxFaceData

    def _getSeparatedIds(self, mesh):
        u"""_tF[X𕪉_ID擾܂.

        :rtype: (list, list, list, list)
        :returns: (uvIds, pointIds, normalIds, Grouped triangles)
        """

        # _tF[X擾
        vtxFaceIds = self._getVtxFaceIds(mesh)

        # ̑̃f[^擾
        triangles = self._getTriangles(mesh)
        numPoints = mesh.numVertices()
        vtxIds = [None] * numPoints

        # e_UVID, @IDƂɕ ----------------------------------
        append = vtxIds.append
        groupKey = lambda x: "%d:%d" % (x[2], x[3])
        for i, v in izip(xrange(numPoints), vtxFaceIds):

            # _tF[X̖_is_j̓XLbv
            if not v:
                continue

            # UVID, @IDƂɒ_tF[XO[v
            groups = getGroupBy(v, key=groupKey, sort=True)

            # ŏ̃O[v𒸓_tF[XXgɐݒ
            vtxIds[i] = groups.pop(0)[0]

            # c̃O[vV_֕
            for group in groups:
                append(group[0])

                # Op`CfbNXC
                for g in group:
                    fvs = triangles[g[1]]
                    oldId = i
                    for j, vi  in enumerate(fvs):
                        if vi == oldId:
                            fvs[j] = numPoints

                numPoints += 1

        # _QIDꂼ̃XgɃApbN
        uvIds = [-1] * numPoints
        poIds = [-1] * numPoints
        nmIds = [-1] * numPoints
        for i, ids in enumerate(vtxIds):
            poIds[i] = ids[0]
            uvIds[i] = ids[2]
            nmIds[i] = ids[3]

        return (uvIds, poIds, nmIds, triangles)

    def _getTriangles(self, mesh):
        u"""Op`CfbN擾܂.

        :type mesh: nt.Mesh
        :rtype: list
        :returns: tF[XɃO[vꂽ_IDXg.
        """

        counts, triangles = mesh.getTriangles()

        # Op`|SCfbNX쐬
        if not mesh.opposite.get():
            for i in xrange(0, len(triangles), 3):
                x = triangles[i]
                triangles[i] = triangles[i + 2]
                triangles[i + 2] = x

        return getGroupByCounts((i * 3 for i in counts), triangles)


class Mesh(NodeObject):

    def __init__(self, trans, boneFact, matFact, indexOffset, setting):
        u"""PyMEL Meshm[hCX^X𐶐܂.

        :param Transform trans: MeshTransform.
        :param int indexOffset: indices̃ItZbgl.
        :type boneFact: BoneFactory
        :type matFact: MaterialFactory
        :type setting: ExportSetting
        """
        removeNs = setting.removeNs
        NodeObject.__init__(self, trans, removeNs)

        # KvȃbVf[^W
        meshData = MeshData(trans, setting.skinMinWeight)

        # {[yуftH[}쐬
        self._bones, deformers = self._getDeformers(trans, meshData, boneFact,
            setting.scale, setting.boneTargetMode)

        # _쐬
        self._vertices = self._getVertices(meshData, deformers, setting.scale)

        # }eA쐬
        self._materials = self._getMaterials(meshData, matFact, indexOffset)

        # [t擾
        self._morphs = getMorphs(meshData, removeNs, indexOffset,
            setting.morphMinOffset, setting.morphSpace)

    def _getDeformers(self, trans, meshData, boneFact, scale, tgtMode):
        u"""Meshm[h{[ƃftH[}쐬܂B

        :returns: (Bone list, Deformer list)
        :rtype: tuple
        """
        # WCgBone쐬
        bones = boneFact.createFromJoints(meshData.joints, tgtMode)

        if bones:
            # {[΃ftH[}쐬
            deformers = [None] * meshData.numPoints
            for i, w in enumerate(meshData.weights):
                if len(w) == 1:
                    d = Bdef1(bones[w[0][0]])
                elif len(w) == 2:
                    d = Bdef2(bones[w[0][0]], bones[w[1][0]], w[0][1])
                elif len(w) == 3:
                    d = Bdef4(bones[w[0][0]], bones[w[1][0]], bones[w[2][0]],
                               None, w[0][1], w[1][1], w[2][1], 0.0)
                else:
                    d = Bdef4(bones[w[0][0]], bones[w[1][0]],
                               bones[w[2][0]], bones[w[3][0]],
                               w[0][1], w[1][1], w[2][1], w[3][1])
                deformers[i] = d
        else:
            # {[Transform쐬
            bones = [boneFact.create(trans)]
            deformers = [Bdef1(bones[0])] * meshData.numPoints

        return (bones, deformers)

    def _getVertices(self, meshData, deformers, scale):
        u"""Meshf[^PMX_f[^쐬܂B

        :type mesh: MeshData
        :type deformers: list of Deformer
        :type scale: float
        :rtype: tuple
        """

        # e_f[^
        points = meshData.points
        uVals = meshData.uValues
        vVals = meshData.vValues
        normals = meshData.normals
        vtxIdIter = izip(meshData.pointIds, meshData.uvIds,
                         meshData.normalIds)

        # _̍쐬
        vertices = []
        append = vertices.append
        for pi, uvi, ni in vtxIdIter:
            p = points[pi]
            u = uVals[uvi]
            v = vVals[uvi]
            n = normals[ni]
            f = 1.0
            d = deformers[pi]
            pos = common.Vector3(p[0] * scale, p[1] * scale, p[2] * scale * -1)
            norm = common.Vector3(n[0], n[1], n[2] * -1)
            uv = common.Vector2(u, v * -1 + 1.0)
            append(pmx.Vertex(pos, norm, uv, d, f))

        return vertices

    def _getMaterials(self, meshData, matFactory, indexOffset):
        u"""Meshf[^}eAf[^쐬܂B

        :type meshData: MeshData
        :type matFactory: MaterialFactory
        :type indexOffset: int
        :rtype: list of Material
        """

        materials = []
        triangles = meshData.triangles
        for sg, faceIds in zip(meshData.shadingEngines, meshData.sgFaceIds):

            # }eA쐬
            mat = matFactory.create(sg)
            materials.append(mat)

            # }eÃCfbNXi[
            extend = mat.indices.extend
            for fid in faceIds:
                extend(i + indexOffset for i in triangles[fid])

        return materials

    @property
    def bones(self):
        """:rtype: list of Bone"""
        return self._bones

    @property
    def vertices(self):
        """:rtype: list of pymeshio.pmx.Vertex"""
        return self._vertices

    @property
    def materials(self):
        """:rtype: list of Material"""
        return self._materials

    @property
    def morphs(self):
        """:rtype: list of Morph"""
        return self._morphs


class Model(pmx.Model):

    #  Magic Methods --------------------------------------------------------

    def __init__(self, transes, direc, setting, msgCallback):
        u"""bVf[^ǂݍPMXf쐬܂B


        :type setting: ExportSetting
        """

        lang = getCurrentLang()
        langExp = lang.Exporter
        pmx.Model.__init__(self)

        # t@Ng[쐬
        texFact = TextureFactory(direc,
                                 setting.texExport,
                                 setting.texFormat,
                                 setting.texMaxSize,
                                 setting.texScale,
                                 setting.texWriteMode,
                                 msgCallback=msgCallback)
        matFact = MaterialFactory(texFact, setting.removeNs)
        boneFact = BoneFactory(setting.removeNs, setting.scale,
                               setting.boneTailMode)

        # ʂ̃bVf[^擾
        for trans in transes:
            msgCallback(langExp.meshFrom + str(trans))
            indexOffset = len(self.vertices)
            mesh = Mesh(trans, boneFact, matFact, indexOffset, setting)
            self.vertices.extend(mesh.vertices)
            self.morphs.extend(mesh.morphs)

        # f[^܂Ƃ߂
        msgCallback(langExp.createModel)
        self.bones = BoneList(boneFact.instances.itervalues())
        self.materials = IndexedList(matFact.instances.itervalues())
        self.textures = IndexedList(t for t in texFact.instances.itervalues()
                                   if t is not None)

        self.materials.sort(fkey=lambda x: x.has_alpha)
        self.bones.update()

        # }eACfbNXo
        for mat in self.materials:
            self.indices.extend(mat.indices)

        # [tZbg擾
        self.morphs.extend(getMorphSets(self.morphs,
                                        removeNs=setting.removeNs))
