# -*- coding: shift-jis -*-
import math
import pymel.core.datatypes as dt
from pymeshio import common
from trutils import between, avg


def listToRGB(L):
    u"""[r, g, b] >> pymeshiol.common.RGB

    :rtype: common.RGB
    """
    r = between(0.0, L[0], 1.0)
    g = between(0.0, L[1], 1.0)
    b = between(0.0, L[2], 1.0)

    return common.RGB(r, g, b)


def listToAlpha(L):
    u"""[r, g, b] >> alpha

    :rtype: float
    """
    return 1.0 - between(0.0, avg(L), 1.0)


def rgbToColor(rgb):
    u"""MeshIO RGBNXColor֕ϊ܂B

    :type rgb: pymeshio.common.RGB
    :rtype: pymel.core.datatypes.Color
    """
    return dt.Color(rgb.r, rgb.g, rgb.b)


def alphaToGlayColor(a):
    u"""At@lO[XP[Color֕ϊ܂B

    :type a: float
    :rtype: pymel.core.datatypes.Color
    """
    return dt.Color(a, a, a)


def pointToVector3(point):
    u"""pymel.core.datatypes.Point >> pymeshio.common.Vector3

    :rtype: common.Vector3
    """
    return common.Vector3(point[0], point[1], point[2])


def specularFactorToRollOff(factor):
    u"""PMX}eAˋxBlinn}eAXyLޒl֕ϊ.

    :param float rolloff: Blinn.specularRollOffl.
    :rtype: float
    """
    safe_factor = max(factor, math.pow(2, -10))  #  2-10
    return math.pow(0.75, math.log(safe_factor, 2) + 1)


def specularRollOffToFactor(rolloff):
    u"""Blinn}eAXyLޒlPMX}eAˋx֕ϊ.

    :param float rolloff: Blinn.specularRollOffl.
    :rtype: float
    """
    sf = between(0.05, rolloff, 1.0)
    log = math.log(sf, 0.75) - 1
    return round(math.pow(2, log), 3)


def getNodeNames(node, rmvNs=True):
    u"""Mayam[h{ꖼƉpꖼ擾܂.

    :param nt.DependNode node: Agr[g擾Ώۂ̃m[hB
    :param bool rmvNs: ^Ȃl[Xy[X𖼑O菜.
    :rtype: (str, str)
    :returns: (name, english_name)
    """

    # Agr[g擾
    jpName, enName = getNodeAttrs(node, ("pmxName", "pmxEnglishName"))
    if not jpName:
        jpName = node.nodeName()
    if not enName:
        enName = node.nodeName()

    if rmvNs:
        jpName = jpName.split(":")[-1]
        enName = enName.split(":")[-1]

    return (jpName, enName)


def getNodeAttrs(node, attrs):
    u"""PyMELm[hw肵Agr[g̒l擾܂B

    :type node: pymel.core.nodetypes.DependNode
    :param attrs: Agr[g񋓂Ce[^B
    :rtype: list
    :returns: ĂȂAgr[gNone܂.
    """

    if isinstance(attrs, basestring):
        attrs = [attrs]

    results = []
    append = results.append
    for attr in attrs:
        if node.hasAttr(attr):
            append(getattr(node, attr).get())
        else:
            append(None)

    return results


class NodeObject(object):
    """Super class of all object including pymel node."""

    def __init__(self, node, rmvNs):
        u"""m[h11ɑΉIuWFNg̋ʂ̏񋟂܂.

        :param node: Nonew肵ꍇ, Agr[g̎擾͍s܂.
        :param rmvNs: ^̏ꍇ, m[hl[Xy[X菜܂.
        :type node: DependNode or None
        :type rmvNs: bool
        """
        self.node = node

        if node is not None:
            # Get names.
            jpName, enName = getNodeNames(node, rmvNs)
            self.name = jpName
            self.english_name = enName

            # Get comment.
            if node.hasAttr("notes"):
                self.comment = node.notes.get()

    def __str__(self):
        if hasattr(self, "english_name"):
            name = self.english_name
        else:
            name = self.node.name()
        clsName = self.__class__.__name__
        return "%s('%s')" % (clsName, name)

    def __repr__(self):
        return self.__str__()
