# -*- coding: shift-jis -*-
import pymel.core.uitypes as ui


def createBasicWindow(title="", width=100, height=100, buttonTexts=[],
                      buttonHeight=30, marginOuter=5, marginInner=5):
    u"""ꂳꂽfUC̃EBhE쐬܂.

    :param title: EBhE^Cg.
    :param width: EBhẺ.
    :param height: EBhȄc.
    :param buttonTexts: {^̕񃊃Xg.
    :param buttonHeight: {^̏c.
    :param marginOuter: t[Õ}[W.
    :param marginInner: t[̃}[W.
    :returns: (Window, Main layout, list of Button)
    """

    # Create window contents.
    window = ui.Window(t=title, w=width, h=height)
    buttons = []
    with ui.AutoLayout() as form:
        with ui.FrameLayout(bv=False, lv=False) as layout:
            pass
        for btnTex in buttonTexts:
            buttons.append(ui.Button(l=btnTex, h=buttonHeight))

    # Attach the main layout to the form layout.
    form.attachForm(layout, "top", marginOuter)
    form.attachForm(layout, "left", marginOuter)
    form.attachForm(layout, "right", marginOuter)
    if buttons:
        form.attachControl(layout, "bottom", marginInner, buttons[0])
    else:
        form.attachForm(layout, "bottom", marginOuter)

    # Attach the buttons to the form layout.
    numButtons = len(buttons)
    width = 100.0 / numButtons
    for i, button in enumerate(buttons):
        marginL = marginOuter if i == 0 else marginInner / 2.0
        marginR = marginOuter if i == numButtons - 1 else marginInner / 2.0

        form.attachNone(button, "top")
        form.attachPosition(button, "left", marginL, i * width)
        form.attachPosition(button, "right", marginR, (i + 1) * width)
        form.attachForm(button, "bottom", marginOuter)

    return (window, layout, buttons)


def _test():
    """Window test."""

    res = createBasicWindow(title="Test Window",
                            width=460,
                            height=340,
                            buttonTexts=("C|[g", ""))
    window = res[0]
    layout = res[1]

    # yCCAEg쐬
    paneLayout = ui.PaneLayout(p=layout, cn="horizontal2")
    paneLayout.setPaneSize((1, 100, 75))

    # ^uCAEg쐬
    tabLayout = ui.TabLayout(tv=True)
    importTab = ui.FrameLayout(bv=False, lv=False, p=tabLayout)
    exportTab = ui.FrameLayout(bv=False, lv=False, p=tabLayout)
    tabLayout.setTabLabel((importTab, u"Import"))
    tabLayout.setTabLabel((exportTab, u"Export"))

    # eLXgtB[h쐬
    ui.ScrollField(ed=False, p=paneLayout)

    window.show()


# _test()
