# -*- coding: shift-jis -*-

import re

import maya.OpenMaya as om
import maya.OpenMayaAnim as oma
import pymel.core as pm
import pymel.core.nodetypes as nt
from . import getDagPath, getVertComponents


def getDeformerBaseMesh(mesh):
    u"""ftH[}̃x[XbV擾܂B

    :type mesh: pymel.core.nodetypes.Mesh or Transform
    :rtype: pymel.core.nodetypes.Mesh or None
    :return: x[XbVȂNoneԂ܂B
    """

    if isinstance(mesh, nt.Mesh):
        mesh = mesh.getParent()

    r = re.compile(".+Orig$")

    shapes = pm.listRelatives(mesh, shapes=True)
    baseMesh = None
    for shape in shapes:
        if r.match(shape.name()):
            baseMesh = shape
            break

    return baseMesh


def getSkinNode(mesh):
    u"""bVɐڑꂽXLNX^m[h擾܂B

    :type mesh: nt.Mesh or nt.Transform
    :rtype: nt.SkinCluster
    """

    # Transform̎͗\MeshɒuĂ
    if isinstance(mesh, nt.Transform):
        mesh = mesh.getShape()

    # qXgHskinCluster
    cmd = "findRelatedSkinCluster(\"%s\")" % str(mesh)
    skinCluster = pm.mel.eval(cmd)  # @UndefinedVariable

    if skinCluster != "":
        return pm.PyNode(skinCluster)
    else:
        return None


def getSkinFn(skinNode):
    u"""XLNX^֐Zbg擾܂B

    :type skinNode: pymel.nodetypes.SkinCluster
    :rtype: maya.OpenMaya.MFnSkinCluster
    """

    skinObj = om.MObject()
    sl = om.MSelectionList()
    sl.add(skinNode.name())
    sl.getDependNode(0, skinObj)
    skinFn = oma.MFnSkinCluster(skinObj)

    return skinFn


def getWeights(mesh, vertIds=None, joints=None):
    u"""bVw肵XLEFCgl擾܂B

    :param mesh: EFCgl擾郁bVB
                 XL΋̃f[^Ԃ܂B
    :type mesh: pymel.core.nodetypes.Mesh
    :param vertIds: l擾钸_ID̃XgB
    :type vertIds: list of int
    :param joints: l擾WCg̃XgB()
    :type joints: list of pymel.core.nodetypes.Joint
    :returns: (Joint̃Xg, EFCgl̃Xg)
    :rtype: (list of joint, list of float)
    """

    numVerts = mesh.numVertices()
    skinNode = getSkinNode(mesh)
    if skinNode:

        skinFn = getSkinFn(skinNode)

        # bVDagPath擾
        meshPath = getDagPath(mesh.fullPath())

        # XLɊ֘AtꂽCtGX̃pXꗗ擾
        infPaths = om.MDagPathArray()
        numInfs = skinFn.influenceObjects(infPaths)

        # SẴCtGX̃CfbNX
        util = om.MScriptUtil()
        util.createFromList(range(numInfs), numInfs)
        infIndices = om.MIntArray(util.asIntPtr(), numInfs)

        # _R|[lg쐬
        ids = range(numVerts) if vertIds is None else vertIds
        components = getVertComponents(ids)

        # EFCgle[u擾
        weights = om.MDoubleArray()
        skinFn.getWeights(meshPath, components, infIndices, weights)

        # Xg
        weights = list(weights)

        # MDagPathPyMEL JointNX擾
        joints = [pm.PyNode(infPaths[i].fullPathName())
                  for i in xrange(numInfs)]

        return (joints, weights)
    else:
        return ([], [])


def compressWeights(weights, numVerts, maxInf=-1,
                      minWeight=0.0, normalize=False, indexOffset=0):
    u"""EFCgl𒸓_ƂɈkf[^擾܂B

    :param weights: SẴEFCgi[ꎟXgB
                    Xg͒_*CtGXɓȂĂ͂ȂȂB
    :type weights: float list
    :param int numVerts: _B
    :param int maxInf: őCtGXB
    :param float minWeight: EFCg̍ŏlB
    :param bool normalize: EFCg𐳋K邩B
    :param int indexOffset: WCgQƂ̃ItZbgB
    :rtype: list of (int, float) list
    :return: result[i][j][k] ... i: _ID
                                 j: _̃EFCgf[^
                                 k: 0 => CtGXIndex
                                    1 => EFCgl
    """

    numWeights = len(weights)
    numInfs = numWeights / numVerts
    compWeights = []
    append = compWeights.append
    keyFunc = lambda x: x[1]
    redFunc = lambda x, y: (0, x[1] + y[1])
    idcs = range(indexOffset, indexOffset + numInfs)

    for wi in range(0, numWeights, numInfs):

        # ŏlȏ̃EFCĝ݂𒊏o
        vertWeights = [(i, weights[j])
                       for i, j in zip(idcs, range(wi, wi + numInfs))
                       if weights[j] > minWeight]

        # EFCgő吔𒴂Ă\[gĐ؂̂Ă
        if 0 < maxInf < len(vertWeights):
            vertWeights.sort(key=keyFunc, reverse=True)
            del vertWeights[maxInf:-1]

        # KKvȂs
        if normalize:
            s = reduce(redFunc, vertWeights)[1]
            if s != 1.0:
                vertWeights = [(w[0], w[1] / s) for w in vertWeights]
        append(vertWeights)

    return compWeights
