# -*- coding: shift-jis -*-
u"""UniqueList̃jbgeXg.

̃XNvgP̂ŎsUniqueList̓eXg܂.
"""

import unittest
from _uniquelist import UniqueList


class Test(unittest.TestCase):

    def _checkMatching(self, size=None):
        u"""listset̃f[^̐Ă邩`FbN܂."""

        s = self._list._set
        isMatch = True
        for i in self._list:
            if not i in s:
                isMatch = False
                break

        self.assertTrue(isMatch)
        if not size is None:
            self.assertEqual(len(s), size)
            self.assertEqual(len(self._list), size)

    def setUp(self):
        self._list = UniqueList(xrange(10))

    def test_contains(self):
        self.assertTrue(0 in self._list)
        self.assertTrue(9 in self._list)
        self.assertFalse(10 in self._list)
        self.assertFalse(None in self._list)
        self._checkMatching(10)

    def test_setitem_int(self):
        self._list[0] = 0
        self.assertEqual(self._list[0], 0)
        self._checkMatching(10)
        self._list[9] = 9
        self.assertEqual(self._list[9], 9)
        self._checkMatching(10)
        self._list[-1] = 10
        self.assertEqual(self._list[-1], 10)
        self._checkMatching(10)
        self._list[5] = 100
        self.assertEqual(self._list[5], 100)
        self._checkMatching(10)
        with self.assertRaises(IndexError):
            self._list[-20] = 100
        self._checkMatching(10)

    def test_setitem_slice(self):
        for step in (-2, -1, 1, 2, None):
            for start in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
                for stop in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
                    for multi in range(-2, 4):
                        self.setUp()
                        try:
                            items = range(3) * multi
                            self._list[start:stop:step] = items
                        except ValueError as ex:
                            print ex
                        self._checkMatching()

    def test_setslice(self):
        for start in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
            for stop in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
                for multi in range(-2, 4):
                    self.setUp()
                    try:
                        items = range(3) * multi
                        self._list[start:stop] = items
                    except ValueError as ex:
                        print ex
                    self._checkMatching()

    def test_delitem_int(self):
        del self._list[0]
        self._checkMatching(9)
        del self._list[-1]
        self._checkMatching(8)
        del self._list[5]
        self._checkMatching(7)
        with self.assertRaises(IndexError):
            del self._list[-20]
        self._checkMatching(7)
        with self.assertRaises(IndexError):
            del self._list[10]
        self._checkMatching(7)

    def test_delitem_slice(self):
        for step in (-2, -1, 1, 2, None):
            for start in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
                for stop in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
                    del self._list[start:stop:step]
                    self._checkMatching()
                    self.setUp()

    def test_delslice(self):
        for start in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
            for stop in (-12, -11, -10, -9, -2, -1, 0, 1, 2, None):
                del self._list[start:stop]
                self._checkMatching()
                self.setUp()

    def test_add(self):
        self._list = self._list + range(5, 15)
        self._checkMatching(15)
        self._list = self._list + xrange(-5, 20)
        self._checkMatching(25)

    def test_iadd(self):
        self._list += range(5, 15)
        self._checkMatching(15)
        self._list += xrange(-5, 20)
        self._checkMatching(25)

    def test_append(self):
        self._list.append(0)
        self._checkMatching(10)
        self._list.append(9)
        self._checkMatching(10)
        self._list.append(10)
        self._checkMatching(11)
        self._list.append(None)
        self._checkMatching(12)
        self._list.append(None)
        self._checkMatching(12)

    def test_extend(self):
        self._list.extend(range(5, 15))
        self._checkMatching(15)
        self._list.extend(xrange(-5, 20))
        self._checkMatching(25)
        self._list.extend([None, 1, 0, None, 100, 10, 100, 200, 100])
        self._checkMatching(28)

    def test_insert(self):
        self._list.insert(-1, -1)
        self._checkMatching(11)
        self._list.insert(0, 10)
        self._checkMatching(12)
        self._list.insert(-100, 100)
        self._checkMatching(13)
        self._list.insert(5, 10)
        self._checkMatching(13)
        self._list.insert(10, None)
        self._checkMatching(14)
        self._list.insert(-1, None)
        self._checkMatching(14)

    def test_remove(self):
        self._list.remove(5)
        self._checkMatching(9)
        self._list.remove(0)
        self._checkMatching(8)
        self._list.remove(9)
        self._checkMatching(7)
        with self.assertRaises(ValueError):
            self._list.remove(5)
        self._checkMatching(7)

    def test_pop(self):
        self.assertEqual(self._list.pop(), 9)
        self._checkMatching(9)
        self.assertEqual(self._list.pop(0), 0)
        self._checkMatching(8)
        self.assertEqual(self._list.pop(5), 6)
        self._checkMatching(7)
        with self.assertRaises(IndexError):
            self._list.pop(10)
        with self.assertRaises(IndexError):
            self._list.pop(-20)
        self._checkMatching(7)


if __name__ == "__main__":
    unittest.main()
