# -*- coding: shift-jis -*-

u"""UniqueList̂ł폜.

{Iɂ͓, ̓XCX̓ۏ.
"""

from itertools import chain


class SetList(list):
    u"""setlist킹RNVłB

    {IlistƓ悤ɈƂł܂AdvfƂ
    o܂B
    dvfǉ悤ƂꍇȀ͎s܂B
    ۂɏꂽmFɂ͊e\bh̖߂l`FbNĂB
    """

    def __init__(self, iterable=None):
        u"""SetList܂B"""

        list.__init__(self,)
        self._set = set()
        if iterable:
            self.extend(iterable)

    def __contains__(self, value):
        u"""setIuWFNggĒl̗LmF܂B"""
        return value in self._set

    def __setitem__(self, _slice, value):
        u"""lݒ肵܂B

        lɃXgɂꍇ͐ݒ͍s܂B
        """
        L = super(self.__class__, self)
        S = self._set

        if isinstance(_slice, slice):
            # XCX
            S.difference_update(L.__getitem__(_slice))
            items = []
            addItem = items.append
            addSet = S.add
            for val in value:
                if not val in S:
                    addItem(val)
                    addSet(val)
            L.__setitem__(_slice, items)
        else:
            # CfbNX
            if not value in S:
                S.remove(L.__getitem__(_slice))
                S.add(value)
                L.__setitem__(_slice, value)

    def __setslice__(self, i, j, iterable):
        u"""XCX͈͂ɕvfݒ肵܂B

        GɂȂ̂stepɂ͑ΉĂ܂.
        """
        self.__setitem__(slice(i, j, 1), iterable)

    def __delitem__(self, _slice):
        u"""l폜܂B"""

        L = super(self.__class__, self)
        S = self._set
        if isinstance(_slice, slice):
            # XCX
            items = L.__getitem__(_slice)
            S.difference_update(items)
            L.__delitem__(_slice)
        else:
            # CfbNX
            item = L.__getitem__(_slice)
            S.remove(item)
            L.__delitem__(_slice)

    def __delslice__(self, i, j):
        u"""XCXŎw肵͈͂̒l폜܂B"""

        self.__delitem__(slice(i, j))

    def __add__(self, iterable):
        u"""ZIy[^"""

        return SetList(chain(self, iterable))

    def __iadd__(self, iterable):
        u"""ȉZIy[^"""

        self.extend(iterable)
        return self

    def __mul__(self, count):
        u"""gps"""
        raise("'SetList' object does not support multiply")

    def __imul__(self, count):
        u"""gps"""

        raise("'SetList' object does not support multiply")

    def append(self, object):
        u"""vf𖖔֒ǉ܂B

        ɃXgɗvf܂܂ĂΒǉ܂B
        :param object: ǉlB
        :rtype: bool
        :return: ǉۂɍsƂ^Ԃ܂B
        """
        if not object in self._set:
            list.append(self, object)
            self._set.add(object)
            return True
        else:
            return False

    def extend(self, iterable):
        u"""Avf𖖔֒ǉ܂B

        ɃXgɊ܂܂Ăvf͒ǉ܂B
        :rtype: list
        :returns: ۂɒǉvf̃XgԂ܂B
        """
        s = self._set
        items = []
        addSet = s.add
        addItem = items.append
        for i in iterable:
            if not i in s:
                addSet(i)
                addItem(i)
        list.extend(self, items)
        return items

    def insert(self, index, object):
        u"""lw肵ʒu֑}܂B

        ɃXgɗvf܂܂ĂΑ}܂B
        :param int index: }ʒuB
        :param object: }l
        :rtype: bool
        :return: ۂɑ}sƂ^Ԃ܂B
        """
        if not object in self._set:
            list.insert(self, index, object)
            self._set.add(object)
            return True
        else:
            return False

    def remove(self, value):
        u"""w肵l菜܂B

        CfbNXŎw肵Ď菜ꍇdel X[_slice]gpĂB

        xlist.remove()ƂقړłB
        :param value: 菜lB
        """
        list.remove(self, value)
        self._set.remove(value)

    def pop(self, _slice):
        u"""w肵CfbNX̗vf菜܂B

        :param int _slice: CfbNXB
        :return: CfbNẌʒuɂvfB
        """
        value = list.pop(self, _slice)
        self._set.remove(value)
        return value

    def _checkMatching(self):
        u"""listset̃f[^̐Ă邩`FbN܂B

        ̃R}h̓fobOpłB
        """
        s = self._set
        isMatch = True
        for i in self:
            if not i in s:
                isMatch = False
                break

        isMatch &= len(self) == len(self._set)

        if not isMatch:
            print "No matching."
            print "list:", self
            print "set :", self._set


def _test():

    print "\nRunTest =========================="

    s = SetList(range(10))
    print "\n__contains__"
    print 5 in s
    print 50 in s
    s._checkMatching()

    print "\n__setitem__"
    a = s[5] = 100
    print a, s
    a = s[6] = 0
    print a, s
    s._checkMatching()

    print "\n__setslice__"
    s = SetList(range(10))
    s[0:3:2] = [100, 110]
    print s
    s[-1:-5:-1] = range(200, 204)
    print s
    s._checkMatching()

    print "\n__delitem__"
    s = SetList(range(10))
    print s
    del s[0]
    print s
    del s[-2]
    print s
    s._checkMatching()

    print "\n__delslice__"
    del s[0:3]
    print s
    del s[-1:-3:-1]
    print s
    s._checkMatching()

    print "\n__add__"
    s = SetList(range(5))
    b = s + range(25, 30)
    print b, b.__class__
    s._checkMatching()

    print "\n__iadd__"
    s += range(100, 105)
    print s, s.__class__
    s._checkMatching()

    print "\nappend"
    s = SetList(range(5))
    s.append(10)
    s.append(-1)
    s.append(3)
    s.append(-1)
    print s
    s._checkMatching()

    print "\nextend"
    s = SetList(range(5))
    s.extend(i * 2 for i in xrange(10))
    print s
    s._checkMatching()

    print "\ninsert"
    s = SetList(range(5))
    s.insert(1, 50)
    s.insert(-1, 10)
    s.insert(5, 0)
    print s
    s._checkMatching()

    print "\nremove"
    s.remove(50)
    s.remove(10)
    print s
    s._checkMatching()

    print "\npop"
    print s.pop(2)
    print s.pop(-1)
    print s
    s._checkMatching()

    print "\nTestCompleted.\n"

# _test()
