# -*- coding: shift-jis -*-
from pmxio.exporter.bone import TargetModes, TailModes
from pmxio.exporter.morph import Spaces
from pmxio.exporter.texture import TextureFormats, WriteModes


class ImportSetting(object):

    def __init__(self):
        self.separateMesh = False
        self.createGrp = True
        self.grpName = ""
        self.createNs = False
        self.nsName = ""
        self.scale = 1.0
        self.jointSize = 1.0
        self.connectAlpha = True


class ExportSetting(object):

    def __init__(self):
        self.scale = 1.0
        self.removeNs = True
        self.skinMinWeight = 0.001
        self.boneTargetMode = TargetModes.TREE
        self.boneTailMode = TailModes.SINGLE
        self.morphExport = True
        self.morphExportSet = True
        self.morphExcludeBase = False
        self.morphMinOffset = 0.001
        self.morphSpace = Spaces.WORLD
        self.texExport = False
        self.texFormat = TextureFormats.PNG
        self.texMaxSize = 1024
        self.texScale = 1.0
        self.texWriteMode = WriteModes.OVERWRITE
