import os.path as ospath


def getExt(path, lower=True):
    """Get an extension without a dot.

    :param str path: A path string.
    :param bool lower: Get the lower case extension.
    :rtype: str
    """
    p = ospath.splitext(path)
    if len(p) <= 1:
        return ""
    else:
        ext = p[-1].replace(".", "")
        return ext.lower() if lower else ext


def isSamePath(path1, path2):
    """Return true, if points to the same file or directory.

    :rtype: bool
    """

    p1 = ospath.normcase(ospath.normpath(path1))
    p2 = ospath.normcase(ospath.normpath(path2))

    return p1 == p2


def getUniqueName(path, start=0, fchar="[", rchar="]"):
    """Get a uniq path in the directory.

    :param str path: File or directory path.
    :param int start: Indexer start number.
    :param str fchar: Character in front of the indexer.
    :param str rchar: Character in rear of the indexer.
    :rtype: str
    """

    # Through path.
    if not ospath.exists(path):
        return path

    # Create unique path.
    pattern = "%%s%s%%d%s%%s" % (fchar, rchar)
    basename, ext = ospath.splitext(path)
    index = start
    while ospath.exists(path):
        path = pattern % (basename, index, ext)
        index += 1

    return path
