# -*- coding: shift-jis -*-

import maya.OpenMaya as om
import pymel.core as pm
import pymel.core.nodetypes as nt
from . import getDagPath, getInvertIDs, getComponentsFromIDs
from skin import getDeformerBaseMesh


def getMeshFn(mesh):
    u"""Meshm[h烁bV֐Zbg擾܂B

    :type mesh: pymel.nodetypes.Mesh or Transform or unicode
    :rtype: maya.OpenMaya.MFnMesh
    """

    if isinstance(mesh, (str, unicode)):
        dagPath = getDagPath(mesh)
    else:
        if isinstance(mesh, nt.Transform):
            mesh = mesh.getShape()
        dagPath = getDagPath(mesh.fullPath())

    return om.MFnMesh(dagPath)


def duplicateFaces(mesh, faceIds):
    u"""qXg炸ɐVbVɃtF[X𕡐܂B

    :type mesh: unicode
    :type faceIds: int list
    :rtype: pymel.core.nodetypes.Transform
    """

    # bV𕡐
    dupMesh = pm.duplicate(mesh)[0]

    # ftH[}̃IWibV΍폜
    orig = getDeformerBaseMesh(dupMesh)
    if orig:
        pm.delete(orig)

    # ]tF[X폜
    numFaces = pm.polyEvaluate(mesh, f=True)
    invertIds = getInvertIDs(faceIds, numFaces)
    delFaces = getComponentsFromIDs(dupMesh, "f", invertIds)

    pm.delete(delFaces, ch=0)

    return dupMesh
