# -*- coding: shift-jis -*-
import pymel.core as pm


def getImageSize(path):
    """Get texture resolution from file path.

    :param str path: Image file path.
    :rtype: tuple
    :returns: (float, float)
    """

    fileNode = pm.shadingNode("file", asTexture=True)
    fileNode.fileTextureName.set(path)
    size = fileNode.outSize.get()
    pm.delete(fileNode)

    return size


def createFileNode(fname="", pname="", path=""):
    u"""place2dTexturem[hڑfilem[h쐬܂.

    :param str name: filem[h. (ȗ)
    :param str name: place2dTexturem[h. (ȗ)
    :param str path: filem[hɎw肷eNX`pX. (ȗ)

    :rtype: tuple
    :returns: (nt.File, nt.Place2DTexture)
    """
    # m[h쐬
    p = "place2dTexture"
    f = "file"
    if not fname:
        fname = f
    if not pname:
        pname = p

    fileNode = pm.shadingNode(f, n=fname, asTexture=True)
    placeNode = pm.shadingNode(p, n=pname, asUtility=True)

    # Agr[gڑ
    placeNode.coverage >> fileNode.coverage
    placeNode.translateFrame >> fileNode.translateFrame
    placeNode.rotateFrame >> fileNode.rotateFrame
    placeNode.mirrorU >> fileNode.mirrorU
    placeNode.mirrorV >> fileNode.mirrorV
    placeNode.stagger >> fileNode.stagger
    placeNode.wrapU >> fileNode.wrapU
    placeNode.wrapV >> fileNode.wrapV
    placeNode.repeatUV >> fileNode.repeatUV
    placeNode.offset >> fileNode.offset
    placeNode.rotateUV >> fileNode.rotateUV
    placeNode.noiseUV >> fileNode.noiseUV
    placeNode.vertexUvOne >> fileNode.vertexUvOne
    placeNode.vertexUvTwo >> fileNode.vertexUvTwo
    placeNode.vertexUvThree >> fileNode.vertexUvThree
    placeNode.vertexCameraOne >> fileNode.vertexCameraOne
    placeNode.outUV >> fileNode.uv
    placeNode.outUvFilterSize >> fileNode.uvFilterSize

    # t@Cm[hɃpXݒ
    try:
        fileNode.fileTextureName.set(path)
    except:
        pass

    return (fileNode, placeNode)
