# -*- coding: shift-jis -*-

from ...trutils import between
import pmxio.trutils.slice as slcutils


class IndexedList(list):

    # Private Methods ---------------------------------------------------------

    def _iter_updater(self, iterable, start):
        u"""CfbNXXVp̃WFl[^擾.

        :param int start: CfbNX̊Jnl.
        :rtype: generator
        """
        def _setval(index, item):
            item.index = index
            return item

        return (_setval(i, v) for i, v in enumerate(iterable, start))

    def _update_indices(self, L, start=None, stop=None):
        u"""w肵͈͂̃CfbNXXV.

        ͈͊ÕCfbNX͎Iɔ͈͓ɏC܂.
        XV(freeze)ĂΏ͍s܂.

        :param list L: Ώۂ̃Xg.
        :param int start: w肵Ȃꍇ 0.
        :param int stop: w肵Ȃꍇ len(L).
        """

        if self._freeze:
            return

        length = len(L)

        # Jnl͈͓ɏC
        if start is None:
            start = 0
        else:
            start = between(0, start, length)

        # Il͈͓ɏC
        if stop is None:
            stop = length
        else:
            stop = between(0, stop, length)

        # CfbNXXV
        for i in xrange(start, stop):
            L[i].index = i

    def __init__(self, iterable=None):
        u"""CX^X."""

        self._freeze = False
        if iterable is None:
            list.__init__(self)
        else:
            list.__init__(self, self._iter_updater(iterable, 0))

    def __setitem__(self, key, item):
        u"""CfNTŗvfݒ.

        :param key: int܂slice. ǂ}CiXl͕␳Ȃ.
        :param item: keysliceȂiterable.
        """
        if isinstance(key, int):
            # CfNT
            list.__setitem__(self, key, item)
            if key < 0:
                key += len(self)
            item.index = key
        else:
            # ɗvfǉĂ
            length = len(self)
            list.__setitem__(self, key, item)
            newLength = len(self)

            # XCX𐳋K
            slc = slcutils.fillDefault(key)
            slc = slcutils.normalize(slc, length, False)
            if slc.step < 0:
                slc = slcutils.flip(slc)
            slc = slcutils.trim(slc, length)

            # CfbNXXV
            if length != newLength:
                self._update_indices(self, slc.start, newLength)
            else:
                self._update_indices(self, slc.start, slc.stop)

    def __setslice__(self, start, stop, items):
        u"""CfNTŗvfݒ.

        slicestepw肵Ȃꍇ炪Ăяo.
        start, stepɃ}CiXl͕␳.
        """
        # ɗvfǉĂ
        length = len(self)
        list.__setslice__(self, start, stop, items)
        newLength = len(self)

        # CfbNXXV
        if start > length:
            start = length
        if length != newLength:
            self._update_indices(self, start, newLength)
        else:
            self._update_indices(self, start, stop)

    def __delitem__(self, key):
        u"""CfNTŗvf폜.

        }CiXl͕␳Ȃ.
        """
        list.__delitem__(self, key)  # step0ȂG[

        if isinstance(key, int):
            # 
            self._update_indices(self, key)
        else:
            # XCX
            slc = slcutils.fillDefault(key)
            if slc.step > 0:
                self._update_indices(self, slc.start)
            else:
                self._update_indices(self, slc.stop + 1)

    def __delslice__(self, start, stop):
        u"""CfNTŗvf폜.

        }CiXl͕␳.
        """
        list.__delslice__(self, start, stop)
        self._update_indices(self, start)

    def __add__(self, other):
        u"""̃XgɐVXgĕԂ.

        :param other: list̂ݗL. tupleNG.
        """
        start = len(self)
        newlist = list.__add__(self, other)
        self._update_indices(newlist, start)
        return newlist

    def __iadd__(self, iterable):
        u"""̃XgiterableǉĕԂ."""
        return list.__iadd__(self, self._iter_updater(iterable, len(self)))

    def extend(self, iterable):
        u"""̃Xgiterableǉ."""
        list.extend(self, self._iter_updater(iterable, len(self)))

    def append(self, object):  # @ReservedAssignment
        u"""P̗vfǉ."""
        object.index = len(self)
        list.append(self, object)

    def insert(self, index, object):  # @ReservedAssignment
        u"""Cӂ̈ʒuɗvfǉ.

        index̃}CiXl͕␳Ȃ.
        CfbNX͈̔͊O0܂͖ɒǉ.
        """
        # \ߒLĂ
        length = len(self)
        list.insert(self, index, object)

        # insert̒ł, ͈͊Oindex𐳂XVłȂ
        index = between(0, index, length)
        self._update_indices(self, start=index)

    def pop(self, index=None):
        u"""Cӂ̈ʒu̗vfoč폜.

        index̃}CiXl͕␳Ȃ.
        CfbNX͈̔͊OIndexError.
        """
        if index is None:
            index = len(self) - 1
        value = list.pop(self, index)

        self._update_indices(self, start=index)
        return value

    def remove(self, value):
        u"""Cӂ̈ʒu̗vfoč폜.

        index̃}CiXl͕␳Ȃ.
        """
        index = list.index(self, value)
        del self[index]

    def sort(self, fcmp=None, fkey=None, reverse=False):
        u"""Cӂ̈ʒu̗vfoč폜.

        index̃}CiXl͕␳Ȃ.
        """
        list.sort(self, fcmp, fkey, reverse)
        self._update_indices(self)

    def reverse(self):
        u"""Cӂ̈ʒu̗vfoč폜.

        index̃}CiXl͕␳Ȃ.
        """
        list.reverse(self)
        self._update_indices(self)

    def freeze(self):
        u"""CfbNX̍XVꎞIɓ܂.

        Aŗvf̒ǉ폜sꍇ, CfbNX̍XVɂ
        ptH[}X̒ቺ\ꍇ, OɃCfbNX
        XV𓀌鎖ɂptH[}X̒ቺhł܂.
        """
        self._freeze = True

    def unfreeze(self):
        u"""CfbNX̍XV̓܂.

        , CfbNX̍č\zs܂.
        """
        self._freeze = False
        self._update_indices(self)
