# -*- coding: shift-jis -*-
u"""PMX}eÃW[.

Material(pmx.Material)
    PMX}eÃf[^NX.
    Blinn, Lambert܂Noneŏ܂.

MaterialFlags
    PMX}eAݒ̒萔NX.

SphereMapModes
    PMXXtBAeNX`ݒ̒萔NX.

"""

import pymel.core.nodetypes as nt
from pmxio.pymeshio import pmx, common
from pmxio.trutils.decorator import memonode
from pmxio.utils import (NodeObject, listToAlpha, listToRGB,
                        specularRollOffToFactor)


class MaterialFactory(object):

    def __init__(self, texFact=None, removeNs=True):
        self._removeNs = removeNs
        self._texFactory = texFact
        self._cache = {}

    @property
    def instances(self):
        """:rtype: dict"""
        return self._cache

    @memonode
    def create(self, node):
        u"""m[hMaterial𐶐܂.

        ̃\bh͈ŃLbV܂.
        ȃm[hw肳ꂽꍇ, ftHg}eA擾܂.

        :type node: Lambert or Blinn or ShadingEngine.
        :rtype: Material
        """
        if isinstance(node, nt.ShadingEngine):
            if node.surfaceShader.inputs():
                node = node.surfaceShader.inputs()[0]

        return Material(node, self._texFactory, self._removeNs)


class Material(pmx.Material, NodeObject):
    u"""PMX}eANXł. """

    def __init__(self, node=None, texFact=None, rmvns=True):
        u"""m[hw肵Material܂.

        :param texFact: eNX`𐶐邽߂̃t@Ng.
        :param node: Nonew肵ꍇ, ftHglŏ.
        :param bool rmvns: ^Ȃl[Xy[X菜܂.
        :type node: Blinn or Lambert or None
        """

        pmx.Material.__init__(self,
                              name=u"sȍގ",
                              english_name=u"Unknown Material",
                              diffuse_color=common.RGB(0.8, 0.8, 0.8),
                              alpha=1.0,
                              specular_factor=5.0,
                              specular_color=common.RGB(0.0, 0.0, 0.0),
                              ambient_color=common.RGB(0.0, 0.0, 0.0),
                              flag=pmx.MATERIALFLAG_GROUNDSHADOW,
                              edge_color=common.RGBA(0.0, 0.0, 0.0, 1.0),
                              edge_size=1.0,
                              texture_index=-1,
                              sphere_texture_index=-1,
                              sphere_mode=pmx.MATERIALSPHERE_NONE,
                              toon_sharing_flag=False,
                              toon_texture_index=-1,
                              comment=u"",
                              vertex_count=0)

        NodeObject.__init__(self, node, rmvns)

        # ̑̃Agr[g
        self.indices = []
        self.texture = None
        self.textureNode = None
        self.index = -1

        # p[^m[h擾
        if isinstance(node, nt.Blinn):
            self._fromBlinn(node, texFact)
        elif isinstance(node, nt.Lambert):
            self._fromLambert(node, texFact)

    def _fromLambert(self, lambert, texFact):
        u"""Lambertm[hMaterialIuWFNg擾܂."""

        # gUJ[
        fileNode = lambert.color.inputs()
        if fileNode:
            # eNX`m[h擾
            self.textureNode = fileNode[0]

            # t@Ngw肳Ă΃eNX`쐬
            if texFact is not None:
                self.texture = texFact.create(self.textureNode)
        else:
            self.diffuse_color = listToRGB(lambert.color.get())

        # ArGgJ[
        fileNode = lambert.ambientColor.inputs()
        if not fileNode:
            self.ambient_color = listToRGB(lambert.ambientColor.get())

        # x
        fileNode = lambert.transparency.inputs()
        if not fileNode:
            self.alpha = listToAlpha(lambert.transparency.get())

    def _fromBlinn(self, blinn, texFact):
        u"""Blinnm[hMaterialIuWFNg擾܂."""

        # LambertƋʕ擾
        self._fromLambert(blinn, texFact)

        # XyLJ[
        fileNode = blinn.specularColor.inputs()
        if not fileNode:
            self.specular_color = listToRGB(blinn.specularColor.get())

        # XyL
        fileNode = blinn.specularRollOff.inputs()
        if not fileNode:
            rollOff = blinn.specularRollOff.get()
            self.specular_factor = specularRollOffToFactor(rollOff)

    def __str__(self):
        return "Material('%s')" % self.english_name

    def __repr__(self):
        return self.__str__()

    @property
    def vertex_count(self):
        u"""̃}eAɑ钸_.

        :rtype: int
        """
        return len(self.indices)

    @property
    def texture_index(self):
        u"""̃}eAĂJ[eNX`̃CfbNX.

        :rtype: int
        """
        if self.texture:
            return self.texture.index
        else:
            return -1

    @property
    def has_alpha(self):
        u"""̃}eAxĂ邩.

        :rtype: bool
        """
        if self.alpha < 1.0:
            return True
        elif self.texture:
            return self.texture.has_alpha
        else:
            return False

    @vertex_count.setter
    def vertex_count(self, val):
        # Dummy
        pass

    @texture_index.setter
    def texture_index(self, val):
        # Dummy
        pass
