# -*- coding: shift-jis -*-

import io
import time
import os.path as op
import pmxio.pymeshio.pmx.writer as pmxwriter
from pmxio.exporter.mesh import Model
from pmxio.language import getCurrentLang


def run(path, transes, setting, msgCallback=lambda x: x):
    u"""w肵bVPMXf[^ƂăGNX|[g܂.

    :param str path: GNX|[gpX.
    :param transes: GNX|[g郁bVgXtH[̃Xg.
    :type transes: list of Transform
    :param setting: GNX|[gݒf[^.
    :type setting: ExportSetting
    :param msgCallback: 2̈֐IuWFNg.
                        message: R[obNbZ[W.
                        isWarning: xtO.
    """

    lang = getCurrentLang()
    langExp = lang.Exporter
    msgCallback(langExp.started, False)
    startTime = time.time()

    # PMXf쐬
    direc = op.dirname(path)
    model = Model(transes, direc, setting, msgCallback)

    # t@Cɏ
    msgCallback(langExp.writeToFile)
    with io.open(path, "wb") as fs:
        pmxwriter.write(fs, model)

    span = time.time() - startTime
    msgCallback(u"%s ( %.4f %s )" % (langExp.completed, span, lang.second))
